/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProject;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenProjectRemoteServerPublisher;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.util.DefaultMaven2OsgiConverter;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.server.remote.IRemoteServerPublisher;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class MavenBundlePluginProject
extends LiferayMavenProject
implements IBundleProject {
    private final String[] ignorePaths = new String[]{"target"};

    public MavenBundlePluginProject(IProject project) {
        super(project);
    }

    @Override
    public <T> T adapt(Class<T> adapterType) {
        T adapter = super.adapt(adapterType);
        if (adapter != null) {
            return adapter;
        }
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)new NullProgressMonitor());
        if (facade != null) {
            if (IProjectBuilder.class.equals(adapterType)) {
                MavenProjectBuilder projectBuilder = new MavenProjectBuilder(this.getProject());
                return adapterType.cast((Object)projectBuilder);
            }
            if (IRemoteServerPublisher.class.equals(adapterType)) {
                MavenProjectRemoteServerPublisher remoteServerPublisher = new MavenProjectRemoteServerPublisher(this.getProject());
                return adapterType.cast((Object)remoteServerPublisher);
            }
            if (IBundleProject.class.equals(adapterType)) {
                return adapterType.cast(this);
            }
        }
        return null;
    }

    public IFile getDescriptorFile(String name) {
        return null;
    }

    public IPath getOutputBundle(boolean buildIfNeeded, IProgressMonitor monitor) throws CoreException {
        IPath targetFile;
        IPath outputJar = null;
        if (buildIfNeeded) {
            MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(this.getProject());
            List<String> goals = Arrays.asList("package");
            try {
                mavenProjectBuilder.execGoals(goals, monitor);
            }
            catch (CoreException e) {
                LiferayMavenCore.logError("Error building package", e);
            }
        }
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), monitor);
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        String targetName = String.valueOf(mavenProject.getBuild().getFinalName()) + ".jar";
        IFolder targetFolder = this.getProject().getFolder("target");
        if (targetFolder.exists() && (targetFile = targetFolder.getRawLocation().append(targetName)).toFile().exists()) {
            outputJar = targetFile;
        }
        return outputJar;
    }

    public String getSymbolicName() throws CoreException {
        String retval = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)monitor);
        MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)monitor);
        Artifact artifact = mavenProject.getArtifact();
        File file = artifact.getFile();
        retval = file != null && file.exists() && !artifact.getFile().getName().equals("classes") ? new DefaultMaven2OsgiConverter().getBundleSymbolicName(artifact) : this.getProject().getLocation().lastSegment();
        return retval;
    }

    public boolean filterResource(IPath resourcePath) {
        return this.filterResource(resourcePath, this.ignorePaths);
    }
}

