/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.core.model.IBaseModel;
import com.liferay.ide.core.model.IModelChangedEvent;
import com.liferay.ide.core.model.IModelChangedListener;
import com.liferay.ide.portlet.core.PluginPackageModel;
import com.liferay.ide.project.ui.dialog.LiferayProjectSelectionDialog;
import com.liferay.ide.ui.form.DefaultContentProvider;
import com.liferay.ide.ui.form.EditableTablePart;
import com.liferay.ide.ui.form.FormLayoutFactory;
import com.liferay.ide.ui.form.IDEFormPage;
import com.liferay.ide.ui.form.TableSection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RequiredDeploymentContextsSection
extends TableSection
implements IModelChangedListener,
IPropertyChangeListener {
    private static final int ADD_INDEX = 0;
    private static final int DOWN_INDEX = 3;
    private static final int REMOVE_INDEX = 1;
    private static final int UP_INDEX = 2;
    private Action fAddAction;
    private Action fRemoveAction;
    private TableViewer fViewer;
    private Vector<String> contexts;

    public RequiredDeploymentContextsSection(IDEFormPage page, Composite parent, String[] labels) {
        super(page, parent, 128, labels);
        this.getSection().setText(Msgs.requiredDeploymentContexts);
        this.getSection().setDescription(Msgs.specifyPlugins);
        this.getSection().getTextClient().getParent().layout(true);
        this.getTablePart().setEditable(true);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fViewer = tablePart.getTableViewer();
        this.fViewer.setContentProvider((IContentProvider)new ContextsContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ContextsLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 250;
        gd.grabExcessVerticalSpace = true;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        section.setLayoutData((Object)gd);
        section.setText(Msgs.serviceDependencies);
        this.createSectionToolbar(section, toolkit);
        this.initialize();
    }

    public void dispose() {
        IBaseModel model = this.getPage().getModel();
        if (model != null) {
            model.dispose();
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void initialize() {
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        if (model == null) {
            return;
        }
        this.fViewer.setInput((Object)model);
        this.updateButtons();
        model.addModelChangedListener((IModelChangedListener)this);
        this.fAddAction.setEnabled(model.isEditable());
        this.fRemoveAction.setEnabled(model.isEditable());
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (event.getChangedProperty() == "portal-dependency-jars" || event.getChangedProperty() == "deploy-excludes" || event.getChangedProperty() == "portal-dependency-tlds" || event.getChangedProperty() == "required-deployment-contexts") {
            this.refresh();
            this.updateButtons();
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void refresh() {
        this.contexts = null;
        this.fViewer.refresh();
        super.refresh();
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getTable().setFocus();
        }
    }

    public boolean setFormInput(Object object) {
        return false;
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        String dep1 = (String)table.getItem(index1).getData();
        String dep2 = (String)table.getItem(index2).getData();
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        model.swapDependencies("required-deployment-contexts", dep1, dep2);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void handleAdd() {
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        final String[] existingServiceDeps = model.getRequiredDeploymentContexts();
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IJavaProject) {
                    IProject project = ((IJavaProject)element).getProject();
                    String[] stringArray = existingServiceDeps;
                    int n = existingServiceDeps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String existingDep = stringArray[n2];
                        if (project.getName().equals(existingDep)) {
                            return false;
                        }
                        ++n2;
                    }
                    return !project.equals((Object)RequiredDeploymentContextsSection.this.getPage().getLiferayFormEditor().getCommonProject());
                }
                return false;
            }
        };
        LiferayProjectSelectionDialog dialog = new LiferayProjectSelectionDialog(this.getPage().getShell(), filter);
        dialog.create();
        if (dialog.open() == 0) {
            Object[] selectedProjects = dialog.getResult();
            try {
                int i = 0;
                while (i < selectedProjects.length) {
                    IJavaProject project = (IJavaProject)selectedProjects[i];
                    if (project.exists()) {
                        model.addRequiredDeploymentContext(project.getProject().getName());
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fViewer.getSelection();
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        int i = 0;
        String[] removedServiceDeps = new String[ssel.size()];
        Iterator iter = ssel.iterator();
        while (iter.hasNext()) {
            removedServiceDeps[i] = iter.next().toString();
            ++i;
        }
        model.removeRequiredDeploymentContexts(removedServiceDeps);
        this.updateButtons();
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void makeActions() {
        this.fAddAction = new Action(Msgs.add){

            public void run() {
                RequiredDeploymentContextsSection.this.handleAdd();
            }
        };
        this.fRemoveAction = new Action(Msgs.remove){

            public void run() {
                RequiredDeploymentContextsSection.this.handleRemove();
            }
        };
    }

    private void updateButtons() {
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        this.updateUpDownButtons();
        tablePart.setButtonEnabled(1, this.isEditable() && hasSelection);
    }

    private void updateUpDownButtons() {
        EditableTablePart tablePart = this.getTablePart();
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1 && selection.length == 1;
        tablePart.setButtonEnabled(2, canMove && this.isEditable() && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && this.isEditable() && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return false;
    }

    protected boolean createCount() {
        return true;
    }

    protected void createServiceDepsArray() {
        this.contexts = new Vector();
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        String[] requiredDeploymentContexts = model.getRequiredDeploymentContexts();
        Collections.addAll(this.contexts, requiredDeploymentContexts);
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void handleDoubleClick(IStructuredSelection sel) {
    }

    protected boolean isDragAndDropEnabled() {
        return false;
    }

    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getFormEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    class ContextsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContextsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (RequiredDeploymentContextsSection.this.contexts == null) {
                RequiredDeploymentContextsSection.this.createServiceDepsArray();
            }
            return RequiredDeploymentContextsSection.this.contexts.toArray();
        }
    }

    class ContextsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ContextsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return element.toString();
            }
            return "";
        }
    }

    private static class Msgs
    extends NLS {
        public static String add;
        public static String remove;
        public static String requiredDeploymentContexts;
        public static String serviceDependencies;
        public static String specifyPlugins;

        static {
            Msgs.initializeMessages((String)RequiredDeploymentContextsSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

