/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model.internal;

import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import java.util.HashSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PortletColumnsValidtionSerivce
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;
    private HashSet<PortletColumnElement> columnsAttachedListener;

    protected void initValidationService() {
        this.columnsAttachedListener = new HashSet();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PortletColumnsValidtionSerivce.this.refresh();
            }
        };
        super.initValidationService();
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        PortletLayoutElement portletLayout = (PortletLayoutElement)this.context(PortletLayoutElement.class);
        LayoutTplElement layoutTpl = (LayoutTplElement)portletLayout.nearest(LayoutTplElement.class);
        int actualWeightSum = 0;
        int exceptedweightSum = (Boolean)layoutTpl.getBootstrapStyle().content() != false ? 12 : 100;
        for (PortletColumnElement col : portletLayout.getPortletColumns()) {
            if (!this.columnsAttachedListener.contains(col)) {
                col.getWeight().attach(this.listener);
                this.columnsAttachedListener.add(col);
            }
            actualWeightSum += ((Integer)col.getWeight().content()).intValue();
        }
        if (actualWeightSum != exceptedweightSum && (exceptedweightSum != 100 || actualWeightSum != 99)) {
            retval = Status.createErrorStatus((String)("The sum of weight of columns should be: " + exceptedweightSum));
        }
        return retval;
    }

    public void dispose() {
        for (PortletColumnElement column : this.columnsAttachedListener) {
            if (column == null || column.disposed()) continue;
            column.detach((Listener)this.listener);
        }
        this.listener = null;
        super.dispose();
    }
}

