/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.AbstractUpgradeProjectHandler;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.job.BuildServiceJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;

public class UpgradeServiceBuilderHandler
extends AbstractUpgradeProjectHandler {
    public Status execute(IProject project, String runtimeName, IProgressMonitor monitor, int perUnit) {
        Status retval = Status.createOkStatus();
        try {
            int worked = 0;
            IProgressMonitor submon = CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)25);
            submon.subTask("Executing build-service for " + project.getName());
            submon.worked(worked += perUnit);
            BuildServiceJob job = new BuildServiceJob(project);
            job.schedule();
            job.join();
            IStatus result = job.getResult();
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            submon.worked(worked += perUnit);
        }
        catch (Exception e) {
            IStatus error = ServiceCore.createErrorStatus("Unable to run service build task for " + project.getName(), e);
            ServiceCore.logError("Unable to run service build task for " + project.getName(), e);
            retval = StatusBridge.create((IStatus)error);
        }
        return retval;
    }
}

