/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.diagram.editor.ShapeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeReorderEvent;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeFactoryModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ShapeFactoryPresentation
extends ShapePresentation {
    private List<ShapePresentation> children = new ArrayList<ShapePresentation>();
    private ShapePresentation separator;
    private int index;
    private Listener shapeReorderListener;
    private Listener shapeAddListener;
    private Listener shapeDeleteListener;

    public ShapeFactoryPresentation(DiagramPresentation parent, ShapeFactoryPart shapeFactoryPart, DiagramResourceCache resourceCache) {
        super(parent, (ShapePart)shapeFactoryPart, resourceCache);
        if (shapeFactoryPart.visible()) {
            ShapePresentation childPresentation = null;
            for (ShapePart shapePart : shapeFactoryPart.getChildren()) {
                childPresentation = ShapePresentation.ShapePresentationFactory.createShapePresentation(this, shapePart, resourceCache);
                this.children.add(childPresentation);
            }
        }
        if (shapeFactoryPart.getSeparator() != null) {
            this.separator = ShapePresentation.ShapePresentationFactory.createShapePresentation(this, shapeFactoryPart.getSeparator(), resourceCache);
            this.separator.setSeparator(true);
        }
    }

    public void init(final ShapeFactoryModel model) {
        this.shapeReorderListener = new FilteredListener<ShapeReorderEvent>(){

            protected void handleTypedEvent(ShapeReorderEvent event) {
                model.handleReorderShapes(ShapeFactoryPresentation.this.part());
            }
        };
        this.part().attach(this.shapeReorderListener);
        this.shapeAddListener = new FilteredListener<ShapeAddEvent>(){

            protected void handleTypedEvent(ShapeAddEvent event) {
                model.handleAddShape((ShapePart)ShapeFactoryPresentation.this.part());
            }
        };
        this.part().attach(this.shapeAddListener);
        this.shapeDeleteListener = new FilteredListener<ShapeDeleteEvent>(){

            protected void handleTypedEvent(ShapeDeleteEvent event) {
                model.handleDeleteShape((ShapePart)ShapeFactoryPresentation.this.part());
            }
        };
        this.part().attach(this.shapeDeleteListener);
    }

    public ShapeFactoryPart part() {
        return (ShapeFactoryPart)super.part();
    }

    public List<ShapePresentation> getChildren() {
        return this.children;
    }

    public void refreshChildren() {
        ArrayList<ShapePresentation> refreshedChildren = new ArrayList<ShapePresentation>();
        ShapeFactoryPart shapeFactoryPart = this.part();
        if (shapeFactoryPart.visible()) {
            for (ShapePart shapePart : shapeFactoryPart.getChildren()) {
                ShapePresentation childPresentation = this.getChildShapePresentation(shapePart);
                if (childPresentation == null) {
                    childPresentation = ShapePresentation.ShapePresentationFactory.createShapePresentation(this, shapePart, this.getResourceCache());
                }
                refreshedChildren.add(childPresentation);
            }
        }
        this.children = refreshedChildren;
    }

    private ShapePresentation getChildShapePresentation(ShapePart shapePart) {
        for (ShapePresentation presentation : this.getChildren()) {
            if (presentation.part() != shapePart) continue;
            return presentation;
        }
        return null;
    }

    public ShapePresentation getSeparator() {
        return this.separator;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.part().detach(this.shapeReorderListener);
        this.part().detach(this.shapeAddListener);
        this.part().detach(this.shapeDeleteListener);
        for (ShapePresentation shapePresentation : this.getChildren()) {
            shapePresentation.dispose();
        }
    }
}

