/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DropDownButton;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ItemButtonController {
    private final DiscoveryItem item;
    private final DropDownButton button;
    private ButtonState primaryState;
    private List<ButtonState> selectableStates;
    private final Menu menu;
    private final MarketplaceViewer viewer;

    public ItemButtonController(MarketplaceViewer marketplaceViewer, DiscoveryItem discoveryItem, DropDownButton button) {
        this.item = discoveryItem;
        this.button = button;
        this.viewer = marketplaceViewer;
        this.updateButtonState();
        this.menu = this.createMenu(button.getButton());
        this.updateAppearance();
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4) {
                    ItemButtonController.this.menuClicked();
                } else {
                    ItemButtonController.this.buttonClicked(ItemButtonController.this.primaryState);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private Menu createMenu(Button button) {
        final Menu menu = new Menu((Control)button);
        this.createMenuItems(menu);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        return menu;
    }

    private void createMenuItems(Menu menu) {
        if (this.selectableStates != null) {
            if (this.primaryState != null) {
                this.createMenuItem(menu, this.primaryState);
            }
            for (ButtonState state : this.selectableStates) {
                this.createMenuItem(menu, state);
            }
        }
    }

    private void createMenuItem(Menu menu, ButtonState state) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setData((Object)state);
        menuItem.setText(state.label);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemButtonController.this.buttonClicked((ButtonState)((Object)e.widget.getData()));
            }
        });
    }

    private void updateMenuItems() {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = this.menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        this.createMenuItems(this.menu);
    }

    private void menuClicked() {
        List<ButtonState> selectableStates = this.getSelectableStates();
        if (selectableStates.isEmpty()) {
            this.buttonClicked(this.primaryState);
            return;
        }
        Rectangle rect = this.button.getButton().getBounds();
        Point p = this.button.getButton().toDisplay(rect.x, rect.y + rect.height);
        this.menu.setLocation(p.x - rect.x, p.y - rect.y);
        this.menu.setVisible(true);
    }

    private void buttonClicked(ButtonState primary) {
        if (primary != ButtonState.DISABLED) {
            primary = primary.nextState();
            this.item.maybeModifySelection(primary.operation);
        }
        this.refresh();
    }

    private void updateButtonState() {
        this.primaryState = ButtonState.DISABLED;
        MarketplaceNodeCatalogItem catalogItem = (MarketplaceNodeCatalogItem)((Object)this.item.getData());
        if (catalogItem.getInstallableUnits().isEmpty()) {
            this.primaryState = ButtonState.DISABLED;
        } else {
            Operation operation = this.item.getSelectedOperation();
            boolean installed = this.isItemInstalled();
            this.selectableStates = Collections.emptyList();
            if (installed) {
                switch (operation) {
                    case UPDATE: {
                        this.primaryState = ButtonState.UPDATE_PENDING;
                        break;
                    }
                    case UNINSTALL: {
                        this.primaryState = ButtonState.UNINSTALL_PENDING;
                        break;
                    }
                    case CHANGE: {
                        this.primaryState = ButtonState.CHANGE_PENDING;
                        break;
                    }
                    case NONE: {
                        this.primaryState = ButtonState.UPDATE;
                        if (this.hasUpdateAvailable()) {
                            this.selectableStates = this.hasOptionalFeatures() ? Arrays.asList(ButtonState.CHANGE, ButtonState.UNINSTALL) : Collections.singletonList(ButtonState.UNINSTALL);
                            break;
                        }
                        this.primaryState = this.hasOptionalFeatures() ? ButtonState.CHANGE : ButtonState.UNINSTALL;
                        this.selectableStates = this.hasOptionalFeatures() ? Collections.singletonList(ButtonState.UNINSTALL) : Collections.emptyList();
                    }
                }
            } else {
                switch (operation) {
                    case INSTALL: {
                        this.primaryState = ButtonState.INSTALL_PENDING;
                        break;
                    }
                    case NONE: {
                        this.primaryState = ButtonState.INSTALL;
                    }
                }
                if (!this.isItemAvailable()) {
                    this.primaryState = ButtonState.DISABLED;
                }
            }
        }
    }

    private List<ButtonState> getSelectableStates() {
        if (this.selectableStates == null) {
            this.updateButtonState();
        }
        return this.selectableStates;
    }

    private boolean hasUpdateAvailable() {
        Boolean available = ((MarketplaceNodeCatalogItem)((Object)this.item.getData())).getUpdateAvailable();
        return available == null || available != false;
    }

    private boolean hasOptionalFeatures() {
        Boolean optional = ((MarketplaceNodeCatalogItem)((Object)this.item.getData())).getHasOptionalFeatures();
        return this.isItemInstalled() && (optional == null || optional != false);
    }

    private boolean isItemInstalled() {
        return ((CatalogItem)this.item.getData()).isInstalled();
    }

    private boolean isItemAvailable() {
        Boolean available = ((CatalogItem)this.item.getData()).getAvailable();
        return available == null || available != false;
    }

    private void updateAppearance() {
        boolean menu;
        boolean relayout = false;
        Button control = this.button.getButton();
        if (!this.primaryState.label.equals(this.button.getText())) {
            int preferredWidth;
            if (this.primaryState == ButtonState.INSTALL) {
                this.button.setFont(JFaceResources.getFontRegistry().getBold(""));
            } else if (this.primaryState.noActionState() == this.primaryState) {
                this.button.setFont(JFaceResources.getFontRegistry().defaultFont());
            } else {
                this.button.setFont(JFaceResources.getFontRegistry().getItalic(""));
            }
            this.button.setText(this.primaryState.label);
            Point preferredSize = control.computeSize(-1, -1);
            ((GridData)control.getLayoutData()).minimumWidth = preferredWidth = preferredSize.x + 10;
            relayout = true;
        }
        control.setEnabled(!this.primaryState.disabled);
        boolean bl = menu = !this.getSelectableStates().isEmpty();
        if (menu != this.button.isShowArrow()) {
            relayout = true;
            this.button.setShowArrow(menu);
        }
        if (relayout) {
            this.item.layout(true, false);
        }
    }

    public void refresh() {
        this.updateButtonState();
        this.updateMenuItems();
        this.updateAppearance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ButtonState {
        INSTALL(Messages.ItemButtonController_install, Operation.NONE, false),
        UNINSTALL(Messages.ItemButtonController_uninstall, Operation.NONE, false),
        INSTALL_PENDING(Messages.ItemButtonController_installPending, Operation.INSTALL, false),
        UNINSTALL_PENDING(Messages.ItemButtonController_uninstallPending, Operation.UNINSTALL, false),
        DISABLED(Messages.ItemButtonController_install, Operation.NONE, true),
        UPDATE_DISABLED(Messages.ItemButtonController_update, Operation.NONE, true),
        UPDATE(Messages.ItemButtonController_update, Operation.NONE, false),
        UPDATE_PENDING(Messages.ItemButtonController_updatePending, Operation.UPDATE, false),
        CHANGE(Messages.ItemButtonController_change, Operation.NONE, false),
        CHANGE_PENDING(Messages.ItemButtonController_changePending, Operation.CHANGE, false);

        final String label;
        private final Operation operation;
        private final boolean disabled;

        private ButtonState(String label, Operation operation, boolean disabled) {
            this.label = label;
            this.operation = operation;
            this.disabled = disabled;
        }

        public ButtonState nextState() {
            switch (this) {
                case INSTALL: {
                    return INSTALL_PENDING;
                }
                case INSTALL_PENDING: {
                    return INSTALL;
                }
                case UNINSTALL: {
                    return UNINSTALL_PENDING;
                }
                case UNINSTALL_PENDING: {
                    return UNINSTALL;
                }
                case UPDATE: {
                    return UPDATE_PENDING;
                }
                case UPDATE_PENDING: {
                    return UPDATE;
                }
                case CHANGE: {
                    return CHANGE_PENDING;
                }
                case CHANGE_PENDING: {
                    return CHANGE;
                }
            }
            return this;
        }

        public ButtonState noActionState() {
            switch (this) {
                case INSTALL_PENDING: {
                    return INSTALL;
                }
                case UNINSTALL_PENDING: {
                    return UNINSTALL;
                }
                case UPDATE_PENDING: {
                    return UPDATE;
                }
                case CHANGE_PENDING: {
                    return CHANGE;
                }
            }
            return this;
        }
    }
}

