/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.widgets;

import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSContext;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSWidgetFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;

public class Java2WSRuntimePreferencesComposite
extends Composite {
    private Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
    private Combo soapBindingCombo;
    private Button createXSDImportsButton;
    private Button generateClientButton;
    private Button generateServerButton;
    private Button generateWrapperFaultBeanButton;
    private Button generateWSDLButton;
    private TabFolder tabFolder;

    public Java2WSRuntimePreferencesComposite(Composite parent, int style, TabFolder tabFolder) {
        super(parent, style);
        this.tabFolder = tabFolder;
    }

    public void addControls() {
        GridLayout preflayout = new GridLayout();
        preflayout.numColumns = 2;
        preflayout.marginHeight = 10;
        this.setLayout((Layout)preflayout);
        GridData gridData = new GridData(4, 4, true, false);
        this.setLayoutData(gridData);
        Group java2wsGroup = new Group((Composite)this, 4);
        java2wsGroup.setText(CXFUIMessages.JAVA2WS_GROUP_LABEL);
        GridLayout java2wslayout = new GridLayout();
        java2wslayout.numColumns = 3;
        java2wslayout.marginHeight = 10;
        java2wsGroup.setLayout((Layout)java2wslayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        java2wsGroup.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createFrontendLabel((Composite)java2wsGroup);
        Combo frontendCombo = Java2WSWidgetFactory.createFrontendCombo((Composite)java2wsGroup, (Java2WSContext)this.context);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        frontendCombo.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createDatabindingLabel((Composite)java2wsGroup);
        Combo databindingCombo = Java2WSWidgetFactory.createDatabindingCombo((Composite)java2wsGroup, (Java2WSContext)this.context);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        databindingCombo.setLayoutData((Object)gridData);
        this.generateClientButton = Java2WSWidgetFactory.createGenerateClientButton((Composite)java2wsGroup, (Java2WSContext)this.context);
        this.generateServerButton = Java2WSWidgetFactory.createGenerateServerButton((Composite)java2wsGroup, (Java2WSContext)this.context);
        this.generateWrapperFaultBeanButton = Java2WSWidgetFactory.createGenerateWrapperFaultBeanButton((Composite)java2wsGroup, (Java2WSContext)this.context);
        this.generateWSDLButton = Java2WSWidgetFactory.createGenerateWSDLButton((Composite)java2wsGroup, (Java2WSContext)this.context);
        this.generateWSDLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2WSRuntimePreferencesComposite.this.enableWSDLGroup(Java2WSRuntimePreferencesComposite.this.generateWSDLButton.getSelection());
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.generateWSDLButton.setLayoutData((Object)gridData);
        Group wsdlGroup = new Group((Composite)java2wsGroup, 16);
        GridLayout wsdlGroupLayout = new GridLayout(2, false);
        wsdlGroup.setLayout((Layout)wsdlGroupLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        wsdlGroup.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createSOAPBindingLabel((Composite)wsdlGroup);
        this.soapBindingCombo = Java2WSWidgetFactory.createSOAPBingCombo((Composite)wsdlGroup, (Java2WSContext)this.context);
        gridData = new GridData(768);
        this.soapBindingCombo.setLayoutData((Object)gridData);
        this.createXSDImportsButton = Java2WSWidgetFactory.createXSDImportsButton((Composite)wsdlGroup, (Java2WSContext)this.context);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.createXSDImportsButton.setLayoutData((Object)gridData);
        Link link = new Link((Composite)this, 0);
        link.setText(CXFUIMessages.ANNOTATIONS_PREFERENCES_LINK);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2WSRuntimePreferencesComposite.this.tabFolder.setSelection(3);
            }
        });
        this.enableWSDLGroup(this.context.isGenerateWSDL());
    }

    protected void enableWSDLGroup(boolean enable) {
        this.soapBindingCombo.setEnabled(enable);
        this.createXSDImportsButton.setEnabled(enable);
    }

    public void setDefaults() {
        if (CXFModelUtils.getDefaultBooleanValue((int)2, (int)12)) {
            this.soapBindingCombo.setText("SOAP 1.2");
        } else {
            this.soapBindingCombo.setText("SOAP 1.1");
        }
        this.createXSDImportsButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)13));
        this.generateClientButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)0, (int)5));
        this.generateServerButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)0, (int)6));
        this.generateWrapperFaultBeanButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)15));
        this.generateWSDLButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)14));
    }

    public void refresh() {
        if (this.context.isSoap12Binding()) {
            this.soapBindingCombo.setText("SOAP 1.2");
        } else {
            this.soapBindingCombo.setText("SOAP 1.1");
        }
        this.createXSDImportsButton.setSelection(this.context.isGenerateXSDImports());
        this.generateClientButton.setSelection(this.context.isGenerateClient());
        this.generateServerButton.setSelection(this.context.isGenerateServer());
        this.generateWrapperFaultBeanButton.setSelection(this.context.isGenerateWrapperFaultBeans());
        this.generateWSDLButton.setSelection(this.context.isGenerateWSDL());
    }

    public void storeValues() {
        if (this.soapBindingCombo.getText().equals("SOAP 1.2")) {
            this.context.setSoap12Binding(true);
        } else {
            this.context.setSoap12Binding(false);
        }
        this.context.setGenerateXSDImports(this.createXSDImportsButton.getSelection());
        this.context.setGenerateClient(this.generateClientButton.getSelection());
        this.context.setGenerateServer(this.generateServerButton.getSelection());
        this.context.setGenerateWrapperFaultBeans(this.generateWrapperFaultBeanButton.getSelection());
        this.context.setGenerateWSDL(this.generateWSDLButton.getSelection());
    }
}

