/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.base.Predicate;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.logging.aeri.ui.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;

class PredicateDebugDecorator<T>
implements Predicate<T> {
    private Predicate<T> predicate;
    private ILog log;
    private static final int DEBUG_STATUS_SEVERITY = 1;
    private static final String DEBUG_STATUS_PLUGIN_ID = "org.eclipse.epp.logging.aeri.ui";

    public PredicateDebugDecorator(Predicate<T> predicate, ILog log) {
        this.predicate = predicate;
        this.log = log;
    }

    public boolean apply(T input) {
        boolean apply = this.predicate.apply(input);
        if (!apply && Constants.DEBUG) {
            if (input instanceof IStatus) {
                this.debugStatus((IStatus)input);
            } else if (input instanceof ErrorReport) {
                this.debugReport((ErrorReport)input);
            }
        }
        return apply;
    }

    private void debugStatus(IStatus inputStatus) {
        if (inputStatus.getSeverity() == 1 && inputStatus.getPlugin().equals(DEBUG_STATUS_PLUGIN_ID)) {
            return;
        }
        String message = MessageFormat.format("Debug: predicate {0} filtered status: {1}", this.predicate.getClass().getSimpleName(), inputStatus.getMessage());
        this.logDebugMessageStatus(message);
    }

    private void debugReport(ErrorReport report) {
        String message = MessageFormat.format("Debug: predicate {0} filtered report: {1}", this.predicate.getClass().getSimpleName(), report.getStatus().getMessage());
        this.logDebugMessageStatus(message);
    }

    private void logDebugMessageStatus(String message) {
        Status status = new Status(1, DEBUG_STATUS_PLUGIN_ID, message);
        this.log.log((IStatus)status);
    }

    public boolean equals(Object object) {
        return this.predicate.equals(object);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }

    public String toString() {
        return this.predicate.toString();
    }
}

