/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core.job;

import com.liferay.ide.sdk.core.SDKJob;
import com.liferay.ide.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.server.tomcat.core.LiferayTomcatServerBehavior;
import com.liferay.ide.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.server.util.ServerUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class CleanAppServerJob
extends SDKJob {
    private final String bundleZipLocation;

    public CleanAppServerJob(IProject project, String bundleZipLocation) {
        super("Clean App Server");
        this.setUser(true);
        this.setProject(project);
        this.bundleZipLocation = bundleZipLocation;
    }

    protected void assertStatus(IStatus status) throws CoreException {
        if (status == null) {
            throw new CoreException(LiferayTomcatPlugin.createErrorStatus("null status"));
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retval = Status.OK_STATUS;
        if (monitor != null) {
            monitor.beginTask(Msgs.runningCleanAppServerTask, -1);
        }
        try {
            IServer[] servers;
            String appServerDir = ServerUtil.getPortalBundle((IProject)this.project).getAppServerDir().toOSString();
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                String mode;
                IServer server = iServerArray[n2];
                String string = mode = server.getServerState() == 2 ? server.getMode() : null;
                if (mode != null && server.getRuntime().getLocation().toOSString().equals(appServerDir)) {
                    LiferayTomcatUtil.syncStopServer(server);
                }
                ++n2;
            }
            IStatus status = this.getSDK().cleanAppServer(this.project, this.bundleZipLocation, appServerDir, monitor);
            this.assertStatus(status);
            IServer[] iServerArray2 = servers;
            int n3 = servers.length;
            n = 0;
            while (n < n3) {
                IModule[] modules;
                IServer server = iServerArray2[n];
                IModule[] iModuleArray = modules = server.getModules();
                int n4 = modules.length;
                int n5 = 0;
                while (n5 < n4) {
                    IModule mod = iModuleArray[n5];
                    IModule[] m = new IModule[]{mod};
                    ((LiferayTomcatServerBehavior)((Object)server.loadAdapter(LiferayTomcatServerBehavior.class, monitor))).setModulePublishState2(m, 3);
                    ++n5;
                }
                ++n;
            }
        }
        catch (Exception ex) {
            retval = LiferayTomcatPlugin.createErrorStatus(ex);
        }
        if (monitor != null) {
            monitor.done();
        }
        return retval;
    }

    private static class Msgs
    extends NLS {
        public static String runningCleanAppServerTask;

        static {
            Msgs.initializeMessages((String)CleanAppServerJob.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

