/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;

public class XMLSearcherManager
extends AbstractRegistryManager {
    private static final String SEARCHER_ELT = "searcher";
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    public static final XMLSearcherManager INSTANCE = new XMLSearcherManager();
    private static final String SEARCHERS_EXTENSION_POINT = "searchers";
    private Map<String, IXMLSearcher> searchersById = null;

    public static XMLSearcherManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.searchersById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addSearcher(this.searchersById, cf);
        }
    }

    private synchronized void addSearcher(Map<String, IXMLSearcher> searchersById, IConfigurationElement[] cf) {
        IXMLSearcher searcher = null;
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (SEARCHER_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    searcher = (IXMLSearcher)ce.createExecutableExtension(CLASS_ATTR);
                    searchersById.put(id, searcher);
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load searcher for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IXMLSearcher getSearcher(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (this.searchersById == null) {
            this.loadSearchers();
        }
        return this.searchersById.get(id);
    }

    private synchronized void loadSearchers() {
        if (this.searchersById != null) {
            return;
        }
        HashMap<String, IXMLSearcher> searchersById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", SEARCHERS_EXTENSION_POINT);
            searchersById = new HashMap(cf.length);
            this.addSearcher(searchersById, cf);
        } else {
            searchersById = new HashMap<String, IXMLSearcher>();
        }
        this.searchersById = searchersById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return SEARCHERS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

