/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.resource;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.search.core.resource.IResourceCollector;
import org.eclipse.wst.xml.search.core.resource.IResourceQuerySpecification;
import org.eclipse.wst.xml.search.core.resource.IResourceRequestor;
import org.eclipse.wst.xml.search.core.resource.ResourceSearchEngine;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToResource;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.resource.ContentAssisitCollectorForResource;
import org.eclipse.wst.xml.search.editor.searchers.resource.HyperlinkCollectorForResource;
import org.eclipse.wst.xml.search.editor.searchers.resource.TextHoverForResource;
import org.eclipse.wst.xml.search.editor.searchers.resource.ValidationResultForResource;
import org.eclipse.wst.xml.search.editor.util.ResourceQuerySpecificationUtil;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;

public class XMLSearcherForResource
implements IXMLSearcher {
    @Override
    public void searchForCompletion(Object selectedNode, String mathingString, String forceBeforeText, String forceEndText, IFile file, IXMLReferenceTo referenceTo, IContentAssistProposalRecorder recorder) {
        IXMLReferenceToResource referencetoResource = (IXMLReferenceToResource)referenceTo;
        ContentAssisitCollectorForResource<Object> collector = new ContentAssisitCollectorForResource<Object>(selectedNode, recorder, referencetoResource.getAdditionalProposalInfoProvider());
        this.internalSearch(selectedNode, file, referencetoResource, collector, mathingString, false);
    }

    @Override
    public void searchForHyperlink(Object selectedNode, int offset, String mathingString, int startOffset, int endOffset, IFile file, IXMLReferenceTo referenceTo, IRegion hyperlinkRegion, List<IHyperlink> hyperLinks, ITextEditor textEditor) {
        IXMLReferenceToResource referencetoResource = (IXMLReferenceToResource)referenceTo;
        HyperlinkCollectorForResource collector = new HyperlinkCollectorForResource(hyperlinkRegion, hyperLinks);
        this.internalSearch(selectedNode, file, referencetoResource, collector, mathingString, true);
    }

    @Override
    public IValidationResult searchForValidation(Object selectedNode, String matchingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        IXMLReferenceToResource referencetoResource = (IXMLReferenceToResource)referenceTo;
        ValidationResultForResource collector = new ValidationResultForResource();
        this.internalSearch(selectedNode, file, referencetoResource, collector, matchingString, true);
        return collector;
    }

    protected void internalSearch(Object selectedNode, IFile file, IXMLReferenceToResource referencetoResource, IResourceCollector collector, String mathingString, boolean fullMatch) {
        IResourceQuerySpecification[] querySpecifications = ResourceQuerySpecificationUtil.getQuerySpecifications(referencetoResource);
        if (querySpecifications == null || querySpecifications.length < 1) {
            return;
        }
        IResourceQuerySpecification querySpecification = null;
        int i = 0;
        while (i < querySpecifications.length) {
            querySpecification = querySpecifications[i];
            IResourceRequestor requestor = querySpecification.getRequestor();
            if (querySpecification.isMultiResource()) {
                IResource[] containers = querySpecification.getResources(selectedNode, (IResource)file);
                ResourceSearchEngine.getDefault().search(selectedNode, containers, requestor, collector, querySpecification.getURIResolver(file, selectedNode), mathingString, fullMatch, null);
            } else {
                IResource container = querySpecification.getResource(selectedNode, (IResource)file);
                ResourceSearchEngine.getDefault().search(selectedNode, container, requestor, collector, querySpecification.getURIResolver(file, selectedNode), mathingString, fullMatch, null);
            }
            ++i;
        }
    }

    @Override
    public String searchForTextHover(Object selectedNode, int offset, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        IXMLReferenceToResource referencetoResource = (IXMLReferenceToResource)referenceTo;
        IContentAssistAdditionalProposalInfoProvider<IResource> provider = referencetoResource.getAdditionalProposalInfoProvider();
        if (provider == null) {
            return null;
        }
        TextHoverForResource collector = new TextHoverForResource(provider);
        this.internalSearch(selectedNode, file, referencetoResource, collector, mathingString, true);
        return collector.getTextInfo();
    }
}

