/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.XMLReferencesUtil;
import org.eclipse.wst.xml.search.editor.validation.AbstractTagValidator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLReferencesValidator
extends AbstractTagValidator {
    @Override
    protected void doValidateStartTag(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter, IFile file, IStructuredModel model) {
        IDOMNode node = DOMUtils.getNodeByOffset((IStructuredModel)model, (int)structuredDocumentRegion.getStartOffset());
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        IDOMElement element = (IDOMElement)node;
        NamedNodeMap map = element.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            IDOMAttr attr = (IDOMAttr)map.item(i);
            IXMLReference reference = XMLReferencesUtil.getXMLReference((Node)attr, file);
            if (reference != null) {
                reference.getValidator().validate(reference, (IDOMNode)attr, file, this, reporter, false);
            }
            ++i;
        }
    }

    @Override
    protected void doValidateXMLContent(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter, IFile file, IStructuredModel model) {
        IDOMNode node = DOMUtils.getNodeByOffset((IStructuredModel)model, (int)structuredDocumentRegion.getStartOffset());
        if (node == null || node.getNodeType() != 3) {
            return;
        }
        IDOMText cfr_ignored_0 = (IDOMText)node;
        IXMLReference reference = XMLReferencesUtil.getXMLReference((Node)node, file);
        if (reference != null) {
            reference.getValidator().validate(reference, node, file, this, reporter, false);
        }
    }
}

