/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.modeling.util.MiscUtil;

public final class SortedSetFactory<E> {
    private final Comparator<E> comparator;
    private Filter<E> filter;
    private E firstElement = null;
    private SortedSet<E> set = null;
    private boolean exported = false;
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final SortedSet<Object> EMPTY_SORTED_SET = new SortedSet<Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length > 0) {
                array[0] = null;
            }
            return array;
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends Object> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparator<? super Object> comparator() {
            return null;
        }

        @Override
        public SortedSet<Object> subSet(Object fromElement, Object toElement) {
            return EMPTY_SORTED_SET;
        }

        @Override
        public SortedSet<Object> headSet(Object toElement) {
            return EMPTY_SORTED_SET;
        }

        @Override
        public SortedSet<Object> tailSet(Object fromElement) {
            return EMPTY_SORTED_SET;
        }

        @Override
        public Object first() {
            return new NoSuchElementException();
        }

        @Override
        public Object last() {
            return new NoSuchElementException();
        }
    };

    private SortedSetFactory(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public static <E> SortedSet<E> empty() {
        return EMPTY_SORTED_SET;
    }

    public static <E> SortedSet<E> singleton(E element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return new SingletonSortedSet<E>(null, element);
    }

    public static <E> SortedSet<E> unmodifiable(E ... elements) {
        return SortedSetFactory.start().add(elements).result();
    }

    public static <E> SortedSet<E> unmodifiable(Collection<E> elements) {
        return SortedSetFactory.start().add(elements).result();
    }

    public static <E> SortedSetFactory<E> start() {
        return SortedSetFactory.start(null);
    }

    public static <E> SortedSetFactory<E> start(Comparator<E> comparator) {
        return new SortedSetFactory<E>(comparator);
    }

    public SortedSetFactory<E> filter(Filter<E> filter) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.filter = filter;
        if (this.filter != null) {
            if (this.set != null) {
                Iterator itr = this.set.iterator();
                while (itr.hasNext()) {
                    if (this.filter.allows(itr.next())) continue;
                    itr.remove();
                }
                int size = this.set.size();
                if (size == 1) {
                    this.firstElement = this.set.first();
                    this.set = null;
                } else if (size == 0) {
                    this.set = null;
                }
            } else if (this.firstElement != null && !this.filter.allows(this.firstElement)) {
                this.firstElement = null;
            }
        }
        return this;
    }

    public SortedSetFactory<E> add(E element) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (element != null && (this.filter == null || this.filter.allows(element))) {
            if (this.set != null) {
                this.set.add(element);
            } else if (this.firstElement != null) {
                this.set = new TreeSet<E>(this.comparator);
                this.set.add(this.firstElement);
                this.set.add(element);
                this.firstElement = null;
            } else {
                this.firstElement = element;
            }
        }
        return this;
    }

    public final SortedSetFactory<E> add(E ... elements) {
        if (elements != null) {
            E[] EArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                E element = EArray[n2];
                this.add(element);
                ++n2;
            }
        }
        return this;
    }

    public SortedSetFactory<E> add(Collection<E> elements) {
        if (elements != null) {
            for (E element : elements) {
                this.add(element);
            }
        }
        return this;
    }

    public boolean remove(E element) {
        boolean removed = false;
        if (element != null) {
            if (this.set != null) {
                removed = this.set.remove(element);
                if (this.set.size() == 1) {
                    this.firstElement = this.set.iterator().next();
                    this.set = null;
                }
            } else if (this.firstElement != null && this.firstElement.equals(element)) {
                removed = true;
                this.firstElement = null;
            }
        }
        return removed;
    }

    public E first() {
        E first;
        if (this.set != null) {
            first = this.set.first();
        } else if (this.firstElement != null) {
            first = this.firstElement;
        } else {
            throw new NoSuchElementException();
        }
        return first;
    }

    public E last() {
        E last;
        if (this.set != null) {
            last = this.set.last();
        } else if (this.firstElement != null) {
            last = this.firstElement;
        } else {
            throw new NoSuchElementException();
        }
        return last;
    }

    public boolean contains(E element) {
        boolean contains = false;
        if (this.set != null) {
            contains = this.set.contains(element);
        } else if (this.firstElement != null && this.firstElement.equals(element)) {
            contains = true;
        }
        return contains;
    }

    public int size() {
        int size = this.set != null ? this.set.size() : (this.firstElement != null ? 1 : 0);
        return size;
    }

    public SortedSet<E> result() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.set != null) {
            return Collections.unmodifiableSortedSet(this.set);
        }
        if (this.firstElement != null) {
            return new SingletonSortedSet<E>(this.comparator, this.firstElement);
        }
        return SortedSetFactory.empty();
    }

    private static final class SingletonSortedSet<E>
    implements SortedSet<E> {
        private final Comparator<E> comparator;
        private final E entry;

        public SingletonSortedSet(Comparator<E> comparator, E entry) {
            this.comparator = comparator;
            this.entry = entry;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object object) {
            return this.comparator == null ? MiscUtil.equal(this.entry, object) : this.comparator.compare(this.entry, object) == 0;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object object : collection) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSortedSet.this.entry;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.entry};
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Object[] a = array;
            if (a.length == 0) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
                a[0] = this.entry;
            } else {
                a[0] = this.entry;
                if (a.length > 1) {
                    a[1] = null;
                }
            }
            return a;
        }

        @Override
        public boolean add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return SortedSetFactory.empty();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return SortedSetFactory.empty();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            if (this.contains(fromElement)) {
                return this;
            }
            return SortedSetFactory.empty();
        }

        @Override
        public E first() {
            return this.entry;
        }

        @Override
        public E last() {
            return this.entry;
        }

        public String toString() {
            return "[" + this.entry.toString() + "]";
        }
    }
}

