/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.search.core.ISimpleXMLSearchEngine;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.internal.Messages;
import org.eclipse.wst.xml.search.core.internal.XMLSearchCorePlugin;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.AllFilesXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchDOMDocumentVisitor;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;
import org.eclipse.wst.xml.search.core.storage.StructuredStorageModelManager;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.eclipse.wst.xml.search.core.xpath.XPathManager;

public abstract class AbstractXMLSearchEngine
implements ISimpleXMLSearchEngine {
    protected boolean isReporterEnabled(IXMLSearchReporter reporter) {
        return reporter != null && reporter.isEnabled();
    }

    protected boolean acceptResource(IResource resource, IResource rootResource, IXMLSearchRequestor requestor) {
        return requestor == null ? false : requestor.accept(resource, rootResource);
    }

    protected void processFile(IFile file, IResource rootResource, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespaces, IXMLSearchDOMNodeCollector collector, Object selectedNode, MultiStatus status) {
        if (this.acceptResource((IResource)file, rootResource, requestor)) {
            IDOMModel domModel = null;
            try {
                domModel = this.getDOMModel(file, status);
                if (domModel != null && requestor.accept((IStructuredModel)domModel)) {
                    try {
                        this.process(visitor, query, xpathProcessorId, namespaces, collector, selectedNode, (IStructuredModel)domModel, domModel);
                    }
                    catch (Throwable e) {
                        status.add(XMLSearchCorePlugin.createStatus(4, NLS.bind((String)Messages.searchEngineDOMDocumentVisitedError, (Object)file.getLocation().toString()), e));
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
    }

    private IDOMModel getDOMModel(IFile file, MultiStatus status) {
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            if (model == null) {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
            }
            if (model instanceof IDOMModel) {
                return (IDOMModel)model;
            }
        }
        catch (Exception e) {
            status.add(XMLSearchCorePlugin.createStatus(4, e.getMessage(), e));
        }
        return null;
    }

    protected void processStorage(IStorage storage, IStorage rootStorage, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespaces, IXMLSearchDOMNodeCollector collector, Object selectedNode, MultiStatus status) {
        IDOMModel domModel = this.getDOMModel(storage, status);
        if (domModel != null) {
            try {
                this.process(visitor, query, xpathProcessorId, namespaces, collector, selectedNode, (IStructuredModel)domModel, domModel);
            }
            catch (Throwable e) {
                status.add(XMLSearchCorePlugin.createStatus(4, NLS.bind((String)Messages.searchEngineDOMDocumentVisitedError, (Object)storage.getFullPath().toString()), e));
            }
        }
    }

    private IDOMModel getDOMModel(IStorage storage, MultiStatus status) {
        try {
            IStructuredModel model = StructuredStorageModelManager.getModelManager().getModel(storage);
            if (model instanceof IDOMModel) {
                return (IDOMModel)model;
            }
        }
        catch (Exception e) {
            status.add(XMLSearchCorePlugin.createStatus(4, e.getMessage(), e));
        }
        return null;
    }

    private void process(IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespaces, IXMLSearchDOMNodeCollector collector, Object selectedNode, IStructuredModel model, IDOMModel domModel) {
        if (model != null) {
            IDOMDocument document = domModel.getDocument();
            if (namespaces != null) {
                NamespaceInfos namespaceInfos = XPathManager.getManager().getNamespaceInfo(document);
                query = namespaces.format(query, namespaceInfos);
            }
            visitor.visit(document, query, xpathProcessorId, collector, selectedNode);
        }
    }

    public IStatus search(IFile[] files, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespaces, IXMLSearchDOMNodeCollector collector, Object selectedNode, IProgressMonitor monitor) {
        MultiStatus status = this.createStatus();
        this.search(files, visitor, query, xpathProcessorId, namespaces, collector, selectedNode, monitor, status);
        return status;
    }

    protected void search(IFile[] files, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespace, IXMLSearchDOMNodeCollector collector, Object selectedNode, IProgressMonitor monitor, MultiStatus status) {
        IFile file = null;
        int i = 0;
        while (i < files.length) {
            file = files[i];
            this.processFile(file, (IResource)file, AllFilesXMLSearchRequestor.INSTANCE, visitor, query, xpathProcessorId, namespace, collector, selectedNode, status);
            ++i;
        }
    }

    protected MultiStatus createStatus() {
        return new MultiStatus("org.eclipse.wst.xml.search.core", 0, Messages.XMLSearchEngine_statusMessage, null);
    }
}

