/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.xml.search.core.queryspecifications.IExecutableXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;

public class FilesOfScopeCalculator
implements IResourceProxyVisitor {
    private final IXMLQuerySpecificationRegistry querySpecificationRegistry;
    private final MultiStatus fStatus;
    private List<IFile> fFiles;

    public FilesOfScopeCalculator(IXMLQuerySpecificationRegistry querySpecificationRegistry, MultiStatus status) {
        this.querySpecificationRegistry = querySpecificationRegistry;
        this.fStatus = status;
    }

    public boolean visit(IResourceProxy proxy) {
        boolean inScope = this.isInScope(proxy);
        if (inScope && proxy.getType() == 1) {
            this.fFiles.add((IFile)proxy.requestResource());
        }
        return inScope;
    }

    public IFile[] process() {
        this.fFiles = new ArrayList<IFile>();
        try {
            Set<IResource> containers = this.querySpecificationRegistry.getQuerySpecificationsMap().keySet();
            block9: for (IResource resource : containers) {
                switch (resource.getType()) {
                    case 1: {
                        resource.accept((IResourceProxyVisitor)this, 0);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        IContainer container = (IContainer)resource;
                        IResource[] roots = container.members();
                        int i = 0;
                        while (i < roots.length) {
                            IResource r = roots[i];
                            if (r.isAccessible()) {
                                r.accept((IResourceProxyVisitor)this, 0);
                            }
                            ++i;
                        }
                        continue block9;
                    }
                }
            }
            IFile[] iFileArray = this.fFiles.toArray(new IFile[this.fFiles.size()]);
            return iFileArray;
        }
        catch (CoreException ex) {
            this.fStatus.add(ex.getStatus());
        }
        finally {
            this.fFiles = null;
        }
        return null;
    }

    private boolean isInScope(IResourceProxy proxy) {
        Collection<Collection<IExecutableXMLQuerySpecification>> values = this.querySpecificationRegistry.getQuerySpecificationsMap().values();
        for (Collection<IExecutableXMLQuerySpecification> collection : values) {
            if (!this.isInScope(proxy, collection)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(IResourceProxy proxy, Collection<IExecutableXMLQuerySpecification> collection) {
        for (IExecutableXMLQuerySpecification executableXMLQuerySpecification : collection) {
            if (!this.isInScope(proxy, executableXMLQuerySpecification)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(IResourceProxy proxy, IExecutableXMLQuerySpecification executableXMLQuerySpecification) {
        IXMLSearchRequestor requestor = executableXMLQuerySpecification.getRequestor();
        return requestor != null ? requestor.accept(proxy.requestResource(), null) : false;
    }
}

