/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.wst.xml.search.core.properties.IPropertiesRequestor;

public class DefaultPropertiesRequestor
implements IPropertiesRequestor {
    public static final IPropertiesRequestor INSTANCE = new DefaultPropertiesRequestor();
    public static final String PROPERTIES_EXT = "properties";
    protected static final String DOT_FOLDER = ".";

    @Override
    public boolean accept(IResource resource, IResource rootResource) {
        int resourceType = resource.getType();
        switch (resourceType) {
            case 8: {
                return this.accept((IWorkspaceRoot)resource, rootResource);
            }
            case 4: {
                return this.accept((IProject)resource, rootResource);
            }
            case 2: {
                return this.accept((IFolder)resource, rootResource);
            }
            case 1: {
                return this.accept((IFile)resource, rootResource);
            }
        }
        return false;
    }

    public boolean accept(IWorkspaceRoot workspaceRoot, IResource rootResource) {
        return true;
    }

    public boolean accept(IProject project, IResource rootResource) {
        return project.isOpen();
    }

    public boolean accept(IFolder folder, IResource rootResource) {
        return !folder.getName().startsWith(DOT_FOLDER);
    }

    protected boolean accept(IFile file, IResource rootResource) {
        return PROPERTIES_EXT.equals(file.getFileExtension());
    }
}

