/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.xpath;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.search.core.internal.XMLSearchCorePlugin;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.core.xpath.DefaultXPathProcessor;
import org.eclipse.wst.xml.search.core.xpath.IXPathManager;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessor;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessorType;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.eclipse.wst.xml.search.core.xpath.XPathProcessorManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathManager
implements IXPathManager {
    private static final IXPathManager INSTANCE = new XPathManager();
    private Map<String, NamespaceInfos> namespaceInfo = new ConcurrentHashMap<String, NamespaceInfos>();

    public static IXPathManager getManager() {
        return INSTANCE;
    }

    @Override
    public NodeList evaluateNodeSet(String xpathFactoryProviderId, Object source, String xpath, NamespaceInfos namespaceInfo, String ... criteria) throws XPathExpressionException {
        return this.getProcessor(xpathFactoryProviderId).evaluateNodeSet(source, xpath, namespaceInfo, criteria);
    }

    @Override
    public String evaluateString(String xpathFactoryProviderId, Object source, String xpath, NamespaceInfos namespaceInfo, String ... criteria) throws XPathExpressionException {
        return this.getProcessor(xpathFactoryProviderId).evaluateString(source, xpath, namespaceInfo, criteria);
    }

    @Override
    public String getXPath(String xpath, String ... args) {
        if (args == null || args.length < 1) {
            return xpath;
        }
        return MessageFormat.format(xpath, args);
    }

    @Override
    public String computeBasicXPath(Node node, NamespaceInfos namespaceInfos) {
        if (node == null) {
            return null;
        }
        StringBuilder xpath = new StringBuilder();
        this.computeBasicXPath(node, xpath, namespaceInfos);
        return xpath.toString();
    }

    private Node computeBasicXPath(Node node, StringBuilder xpath, NamespaceInfos namespaceInfos) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                this.computeBasicXPath((Attr)node, xpath, namespaceInfos);
                return null;
            }
            case 3: {
                this.computeBasicXPath((Text)node, xpath, namespaceInfos);
                return null;
            }
            case 1: {
                return this.computeBasicXPath((Element)node, xpath, namespaceInfos);
            }
        }
        return null;
    }

    private Node computeBasicXPath(Element element, StringBuilder xpath, NamespaceInfos namespaceInfos) {
        String prefix;
        xpath.insert(0, element.getLocalName());
        if (!StringUtils.isEmpty(element.getNamespaceURI()) && namespaceInfos != null && (prefix = namespaceInfos.getPrefix(element.getNamespaceURI())) != null) {
            xpath.insert(0, ":");
            xpath.insert(0, prefix);
        }
        xpath.insert(0, "/");
        Node parentNode = element;
        while (parentNode != null && parentNode.getNodeType() != 9) {
            parentNode = parentNode.getParentNode();
            parentNode = this.computeBasicXPath(parentNode, xpath, namespaceInfos);
        }
        return parentNode;
    }

    private void computeBasicXPath(Attr attr, StringBuilder xpath, NamespaceInfos namespaceInfos) {
        this.computeBasicXPath(attr.getOwnerElement(), xpath, namespaceInfos);
        xpath.append("[@");
        xpath.append(attr.getName());
        xpath.append("=");
        this.addXPathConditionValue(attr.getValue(), xpath);
        xpath.append("]");
        xpath.append("/@");
        xpath.append(attr.getName());
    }

    private void computeBasicXPath(Text text, StringBuilder xpath, NamespaceInfos namespaceInfos) {
        this.computeBasicXPath(text.getParentNode(), xpath, namespaceInfos);
        xpath.append("[text()=");
        this.addXPathConditionValue(text.getData(), xpath);
        xpath.append("]");
        xpath.append("/text()");
    }

    private void addXPathConditionValue(String value, StringBuilder xpath) {
        char c = this.getEnclosingXPathCondition(value);
        xpath.append(c);
        xpath.append(value);
        xpath.append(c);
    }

    private char getEnclosingXPathCondition(String value) {
        if (value.indexOf("\"") != -1) {
            return '\'';
        }
        return '\"';
    }

    private IXPathProcessor getProcessor(String id) {
        if (id == null) {
            return DefaultXPathProcessor.INSTANCE;
        }
        IXPathProcessorType processorType = XPathProcessorManager.getDefault().getProcessor(id);
        if (processorType == null) {
            throw new RuntimeException("Cannot retrieve XPath processor type with id=" + id);
        }
        IXPathProcessor processor = processorType.getProcessor();
        if (processor == null) {
            throw new RuntimeException("Null XPath processor for XPath processor with id=" + id);
        }
        return processor;
    }

    @Override
    public IStatus validateXPath(String xpathFactoryProviderId, String xpath) {
        IXPathProcessor processor = null;
        try {
            processor = this.getProcessor(xpathFactoryProviderId);
        }
        catch (Throwable e) {
            return XMLSearchCorePlugin.createStatus(4, "", e);
        }
        return processor.validateXPath(xpath);
    }

    @Override
    public NamespaceInfos getNamespaceInfo(Node node) {
        if (node.getNodeType() == 9) {
            return this.getNamespaceInfo((IDOMDocument)node);
        }
        return this.getNamespaceInfo((IDOMDocument)node.getOwnerDocument());
    }

    @Override
    public NamespaceInfos getNamespaceInfo(IDOMDocument document) {
        String modelID = document.getModel().getId();
        Map<String, NamespaceInfos> namespaceInfo = this.getNamespaceInfo();
        NamespaceInfos info = namespaceInfo.get(modelID);
        if (info == null && document.getDocumentElement() != null) {
            info = new NamespaceInfos();
            NamespaceTable namespaceTable = new NamespaceTable((Document)document);
            namespaceTable.visitElement(document.getDocumentElement());
            Collection namespaces = namespaceTable.getNamespaceInfoCollection();
            info.addAll(namespaces);
            namespaceInfo.put(modelID, info);
            this.setNamespaceInfo(namespaceInfo);
        }
        return info;
    }

    public void setNamespaceInfo(Map<String, NamespaceInfos> namespaceInfo) {
        this.namespaceInfo = namespaceInfo;
    }

    public Map<String, NamespaceInfos> getNamespaceInfo() {
        return this.namespaceInfo;
    }
}

