/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.ILiferayProjectImportDataModelProperties;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class LiferayProjectImportOperation
extends AbstractDataModelOperation
implements ILiferayProjectImportDataModelProperties {
    public LiferayProjectImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProjectRecord projectRecord = (ProjectRecord)this.getDataModel().getProperty("ILiferayProjectImportDataModelProperties.PROJECT_RECORD");
        if (projectRecord == null) {
            return ProjectCore.createErrorStatus("Project record to import is null.");
        }
        File projectDir = projectRecord.getProjectLocation().toFile();
        SDK sdk = SDKUtil.getSDKFromProjectDir((File)projectDir);
        if (sdk != null && !SDKManager.getInstance().containsSDK(sdk)) {
            SDKManager.getInstance().addSDK(sdk);
        }
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        try {
            ProjectImportUtil.importProject(projectRecord, runtime, sdk.getLocation().toOSString(), monitor);
        }
        catch (CoreException e) {
            return ProjectCore.createErrorStatus((Exception)((Object)e));
        }
        return Status.OK_STATUS;
    }
}

