/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class ProjectNameListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        ProjectNameListener.updateLocation(this.op(event));
    }

    protected NewLiferayPluginProjectOp op(PropertyContentEvent event) {
        return (NewLiferayPluginProjectOp)event.property().element().nearest(NewLiferayPluginProjectOp.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateLocation(NewLiferayPluginProjectOp op) {
        String currentProjectName = (String)op.getProjectName().content();
        if (currentProjectName == null) {
            return;
        }
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        String providerShortName = ((NewLiferayProjectProvider)op.getProjectProvider().content(true)).getShortName();
        if (!useDefaultLocation) return;
        Path newLocationBase = null;
        if (providerShortName.equals("ant")) {
            Path sdkPath;
            SDK sdk = null;
            try {
                sdk = SDKUtil.getWorkspaceSDK();
            }
            catch (CoreException coreException) {}
            if (sdk == null && op.getSdkLocation() != null && (sdkPath = (Path)op.getSdkLocation().content()) != null) {
                IPath sdkLocation = PathBridge.create((Path)sdkPath);
                sdk = SDKUtil.createSDKFromLocation((IPath)sdkLocation);
            }
            if (sdk == null) return;
            Path sdkLocation = PathBridge.create((IPath)sdk.getLocation());
            switch ((PluginType)((Object)op.getPluginType().content(true))) {
                case portlet: 
                case servicebuilder: {
                    newLocationBase = sdkLocation.append("portlets");
                    break;
                }
                case ext: {
                    newLocationBase = sdkLocation.append("ext");
                    break;
                }
                case hook: {
                    newLocationBase = sdkLocation.append("hooks");
                    break;
                }
                case layouttpl: {
                    newLocationBase = sdkLocation.append("layouttpl");
                    break;
                }
                case theme: {
                    newLocationBase = sdkLocation.append("themes");
                    break;
                }
                case web: {
                    newLocationBase = sdkLocation.append("webs");
                }
            }
        } else {
            newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
        }
        if (newLocationBase == null) return;
        NewLiferayPluginProjectOpMethods.updateLocation(op, newLocationBase);
    }
}

