/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.modules.BaseModuleOp;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class ModuleProjectNameValidationService
extends ValidationService {
    private static final String PROJECT_NAME_REGEX = "[A-Za-z0-9_\\-.]+";
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!(event.property().definition().equals(BaseModuleOp.PROP_FINAL_PROJECT_NAME) || event.property().definition().equals(BaseModuleOp.PROP_PROJECT_NAMES) || event.property().definition().equals(ProjectName.PROP_PROJECT_NAME))) {
                    ModuleProjectNameValidationService.this.refresh();
                }
            }
        };
        this.op().attach((Listener)this.listener, "*");
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        BaseModuleOp op = this.op();
        String currentProjectName = (String)op.getProjectName().content();
        if (currentProjectName != null) {
            IStatus nameStatus = CoreUtil.getWorkspace().validateName(currentProjectName, 4);
            if (!nameStatus.isOK()) {
                retval = StatusBridge.create((IStatus)nameStatus);
            } else if (this.isInvalidProjectName(op)) {
                retval = Status.createErrorStatus((String)"A project with that name already exists.");
            } else if (!this.isValidProjectName(currentProjectName)) {
                retval = Status.createErrorStatus((String)"The project name is invalid for a gradle project");
            } else {
                org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)op.getLocation().content(true);
                if (currentProjectName != null && currentProjectLocation != null) {
                    String currentPath = currentProjectLocation.toOSString();
                    IPath osPath = Path.fromOSString((String)currentPath);
                    IStatus projectStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(currentProjectName, osPath);
                    if (!projectStatus.isOK()) {
                        retval = StatusBridge.create((IStatus)projectStatus);
                    }
                }
            }
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        this.op().detach((Listener)this.listener, "*");
    }

    private boolean isInvalidProjectName(BaseModuleOp op) {
        String projectName = (String)op.getProjectName().content(true);
        return CoreUtil.getProject((String)projectName).exists();
    }

    private boolean isValidProjectName(String currentProjectName) {
        return currentProjectName.matches(PROJECT_NAME_REGEX);
    }

    private BaseModuleOp op() {
        return (BaseModuleOp)this.context(BaseModuleOp.class);
    }
}

