/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import aQute.remote.api.Agent;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalServerBehavior;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wst.server.core.IServer;

public class ServiceCommand {
    private final IServer _server;
    private String _serviceName;

    public ServiceCommand(IServer server) {
        this._server = server;
    }

    public ServiceCommand(IServer server, String serviceName) {
        this._serviceName = serviceName;
        this._server = server;
    }

    private File checkStaticServicesFile() throws IOException {
        URL url = FileLocator.toFileURL((URL)ProjectCore.getDefault().getBundle().getEntry("OSGI-INF/services-static.json"));
        File servicesFile = new File(url.getFile());
        if (servicesFile.exists()) {
            return servicesFile;
        }
        throw new FileNotFoundException("can't find static services file services-static.json");
    }

    public String[] execute() throws Exception {
        BundleSupervisor supervisor = null;
        String[] result = null;
        try {
            if (this._server == null) {
                result = this._serviceName == null ? this.getStaticServices() : this.getStaticServiceBundle(this._serviceName);
                String[] stringArray = result;
                return stringArray;
            }
            PortalServerBehavior serverBehavior = (PortalServerBehavior)this._server.loadAdapter(PortalServerBehavior.class, null);
            supervisor = serverBehavior.getBundleSupervisor();
            if (supervisor == null && this._server == null) {
                result = this._serviceName == null ? this.getStaticServices() : this.getStaticServiceBundle(this._serviceName);
                String[] stringArray = result;
                return stringArray;
            }
            if (!((Agent)supervisor.getAgent()).redirect(-1)) {
                return null;
            }
            result = this._serviceName == null ? this.getServices(supervisor) : this.getServiceBundle(this._serviceName, supervisor);
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            if (supervisor != null) {
                ((Agent)supervisor.getAgent()).redirect(0);
            }
        }
    }

    private String[] getServiceBundle(String serviceName, BundleSupervisor supervisor) throws Exception {
        String[] serviceBundleInfo;
        ((Agent)supervisor.getAgent()).stdin("packages " + serviceName.substring(0, serviceName.lastIndexOf(".")));
        if (supervisor.getOutInfo().startsWith("No exported packages")) {
            ((Agent)supervisor.getAgent()).stdin("services (objectClass=" + serviceName + ")" + " | grep \"Registered by bundle:\" ");
            serviceBundleInfo = this.parseRegisteredBundle(supervisor.getOutInfo());
        } else {
            serviceBundleInfo = this.parseSymbolicName(supervisor.getOutInfo());
        }
        return serviceBundleInfo;
    }

    private String[] getServices(BundleSupervisor supervisor) throws Exception {
        ((Agent)supervisor.getAgent()).stdin("services");
        return this.parseService(supervisor.getOutInfo());
    }

    private String[] getStaticServiceBundle(String _serviceName) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        File servicesFile = this.checkStaticServicesFile();
        Map map = (Map)mapper.readValue(servicesFile, Map.class);
        List serviceBundle = (List)map.get(_serviceName);
        if (serviceBundle != null && serviceBundle.size() != 0) {
            return serviceBundle.toArray(new String[serviceBundle.size()]);
        }
        return null;
    }

    private String[] getStaticServices() throws Exception {
        File servicesFile = this.checkStaticServicesFile();
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(servicesFile, Map.class);
        String[] services = map.keySet().toArray(new String[0]);
        return services;
    }

    private String[] parseRegisteredBundle(String serviceName) {
        if (serviceName.startsWith("false")) {
            return null;
        }
        String str = serviceName.substring(0, serviceName.indexOf("["));
        String[] result = (str = str.replaceAll("\"Registered by bundle:\"", "").trim()).split("_");
        if (result.length == 2) {
            return result;
        }
        return null;
    }

    private String[] parseService(String outinfo) {
        Pattern pattern = Pattern.compile("(?<=\\{)(.+?)(?=\\})");
        Matcher matcher = pattern.matcher(outinfo);
        ArrayList<String> ls = new ArrayList<String>();
        while (matcher.find()) {
            ls.add(matcher.group());
        }
        Iterator iterator = ls.iterator();
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            if (!serviceName.contains("bundle.id=") && !serviceName.contains("service.id=") && !serviceName.contains("=")) continue;
            iterator.remove();
        }
        ArrayList<String> listservice = new ArrayList<String>();
        for (String bs : ls) {
            if (bs.split(",").length > 1) {
                String[] stringArray = bs.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String bbs = stringArray[n2];
                    listservice.add(bbs.trim());
                    ++n2;
                }
                continue;
            }
            listservice.add(bs);
        }
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> newList = new ArrayList<String>();
        for (String element : listservice) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        Collections.sort(newList);
        return newList.toArray(new String[0]);
    }

    private String[] parseSymbolicName(String info) {
        int symbolicIndex = info.indexOf("bundle-symbolic-name");
        int versionIndex = info.indexOf("version:Version");
        if (symbolicIndex != -1 && versionIndex != -1) {
            String symbolicName = info.substring(symbolicIndex, info.indexOf(";", symbolicIndex));
            String version = info.substring(versionIndex, info.indexOf(";", versionIndex));
            Pattern p = Pattern.compile("\"([^\"]*)\"");
            Matcher m = p.matcher(symbolicName);
            while (m.find()) {
                symbolicName = m.group(1);
            }
            m = p.matcher(version);
            while (m.find()) {
                version = m.group(1);
            }
            return new String[]{symbolicName, version};
        }
        return null;
    }
}

