/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.upgrade;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.AbstractUpgradeProjectHandler;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class UpgradeRuntimeHandler
extends AbstractUpgradeProjectHandler {
    @Override
    public Status execute(IProject project, String runtimeName, IProgressMonitor monitor, int perUnit) {
        Status retval = Status.createOkStatus();
        try {
            int worked = 0;
            IProgressMonitor submon = CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)25);
            submon.subTask("Update project runtime");
            IRuntime runtime = RuntimeManager.getRuntime((String)runtimeName);
            if (runtime != null) {
                IFacetedProject fProject;
                IRuntime primaryRuntime;
                submon.worked(worked += perUnit);
                if (runtime != null && !runtime.equals(primaryRuntime = (fProject = ProjectUtil.getFacetedProject(project)).getPrimaryRuntime())) {
                    submon.worked(worked += perUnit);
                    fProject.setTargetedRuntimes(Collections.singleton(runtime), monitor);
                    submon.worked(worked += perUnit);
                    fProject.setPrimaryRuntime(runtime, monitor);
                    submon.worked(worked += perUnit);
                }
            }
        }
        catch (Exception e) {
            IStatus error = ProjectCore.createErrorStatus("Unable to upgrade target runtime for " + project.getName(), e);
            ProjectCore.logError(error);
            retval = StatusBridge.create((IStatus)error);
        }
        return retval;
    }
}

