/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class LiferayWorkspaceUtil {
    public static String multiWorkspaceError = "More than one Liferay workspace build in current Eclipse workspace";
    public static String hasLiferayWorkspaceMsg = "A Liferay Workspace project already exists in this Eclipse instance.";
    private static final Pattern PATTERN_WORKSPACE_PLUGIN = Pattern.compile(".*apply\\s*plugin\\s*:\\s*['\"]com\\.liferay\\.workspace['\"]\\s*$", 40);

    public static IStatus validateWorkspacePath(String currentPath) {
        IStatus retVal = ProjectImportUtil.validatePath(currentPath);
        if (retVal.isOK() && !LiferayWorkspaceUtil.isValidWorkspaceLocation(currentPath)) {
            retVal = ProjectCore.createErrorStatus("Invalid Liferay Workspace");
        }
        return retVal;
    }

    public static void clearWorkspace(String location) {
        File settings;
        File classpathFile;
        File projectFile = new File(location, ".project");
        if (projectFile.exists()) {
            projectFile.delete();
        }
        if ((classpathFile = new File(location, ".classpath")).exists()) {
            classpathFile.delete();
        }
        if ((settings = new File(location, ".settings")).exists() && settings.isDirectory()) {
            FileUtil.deleteDir((File)settings, (boolean)true);
        }
    }

    public static boolean isValidWorkspaceLocation(String location) {
        File workspaceDir = new File(location);
        File buildGradle = new File(workspaceDir, "build.gradle");
        File settingsGradle = new File(workspaceDir, "settings.gradle");
        File gradleProperties = new File(workspaceDir, "gradle.properties");
        if (!(buildGradle.exists() && settingsGradle.exists() && gradleProperties.exists())) {
            return false;
        }
        String settingsContent = FileUtil.readContents((File)settingsGradle, (boolean)true);
        return settingsContent != null && PATTERN_WORKSPACE_PLUGIN.matcher(settingsContent).matches();
    }

    public static boolean isValidWorkspace(IProject project) {
        return project != null && project.getLocation() != null && LiferayWorkspaceUtil.isValidWorkspaceLocation(project.getLocation().toOSString());
    }

    public static boolean hasBundlesDir(String location) {
        File bundles = new File(location, "bundles");
        return bundles.exists() && bundles.isDirectory();
    }

    public static boolean hasLiferayWorkspace() throws CoreException {
        IProject[] projects = CoreUtil.getAllProjects();
        int count = 0;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (LiferayWorkspaceUtil.isValidWorkspace(project)) {
                ++count;
            }
            ++n2;
        }
        if (count == 1) {
            return true;
        }
        if (count > 1) {
            throw new CoreException(ProjectCore.createErrorStatus(multiWorkspaceError));
        }
        return false;
    }

    public static IProject getLiferayWorkspaceProject() {
        IProject[] projects;
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (LiferayWorkspaceUtil.isValidWorkspace(project)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static String getLiferayWorkspaceProjectModulesDir(IProject project) {
        IPath gradlePropertiesLocation;
        IPath projectLocation;
        String retval = null;
        if (project != null && (projectLocation = project.getLocation()) != null && (gradlePropertiesLocation = projectLocation.append("gradle.properties")).toFile().exists()) {
            try {
                String modulesDir = CoreUtil.readPropertyFileValue((File)gradlePropertiesLocation.toFile(), (String)"liferay.workspace.modules.dir");
                if (modulesDir == null) {
                    modulesDir = "modules";
                }
                retval = modulesDir;
            }
            catch (IOException e) {
                ProjectCore.logError("Can't read gradle properties from workspaceProject. ", e);
            }
        }
        return retval;
    }
}

