/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.ui.action;

import com.liferay.ide.gradle.core.modules.OSGiCustomJSP;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sapphire.ElementList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class OSGiBundleFileSelectionDialog
extends ElementTreeSelectionDialog {
    private static ElementList<OSGiCustomJSP> jsps;

    public OSGiBundleFileSelectionDialog(Shell parent, ElementList<OSGiCustomJSP> currentJSPs) {
        super(parent, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider());
        jsps = currentJSPs;
        this.setComparator(new ViewerComparator());
    }

    protected static class FileContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        protected FileContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.EMPTY;
        }

        public Object[] getElements(Object element) {
            File file;
            HashSet<String> possibleValues = new HashSet<String>();
            if (element instanceof File && (file = (File)element).exists()) {
                try {
                    Object object = null;
                    Object var5_6 = null;
                    try (JarFile jar = new JarFile(file);){
                        Enumeration<JarEntry> enu = jar.entries();
                        while (enu.hasMoreElements()) {
                            JarEntry entry = enu.nextElement();
                            String name = entry.getName();
                            if (!name.startsWith("META-INF/resources/") || !name.endsWith(".jsp") && !name.endsWith(".jspf")) continue;
                            possibleValues.add(name);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException iOException) {}
            }
            for (OSGiCustomJSP jsp : jsps) {
                String jspFile = (String)jsp.getValue().content();
                possibleValues.remove(jspFile);
            }
            return possibleValues.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class FileLabelProvider
    extends LabelProvider {
        private final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        protected FileLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.IMG_FILE;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

