/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.osgi.service.prefs.BackingStoreException;

public class RepositoryUtil {
    public static final String PREFS_DIRECTORIES = "GitRepositoriesView.GitDirectories";
    private final Map<String, Map<String, String>> commitMappingCache = new HashMap<String, Map<String, String>>();
    private final Map<String, String> repositoryNameCache = new HashMap<String, String>();
    private final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(Activator.getPluginId());

    RepositoryUtil() {
    }

    void dispose() {
        this.commitMappingCache.clear();
        this.repositoryNameCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String mapCommitToRef(Repository repository, String commitId, boolean refresh) {
        Map<String, Map<String, String>> map = this.commitMappingCache;
        synchronized (map) {
            TreeSet<String> branchNames;
            block44: {
                if (ObjectId.isId((String)commitId)) break block44;
                return null;
            }
            try {
                ReflogReader reflogReader = repository.getReflogReader("HEAD");
                if (reflogReader != null) {
                    List lastEntry = reflogReader.getReverseEntries();
                    for (Object entry : lastEntry) {
                        ObjectId id;
                        CheckoutEntry checkoutEntry;
                        if (!entry.getNewId().name().equals(commitId) || (checkoutEntry = entry.parseCheckout()) == null) continue;
                        Ref ref = repository.getRef(checkoutEntry.getToBranch());
                        if (ref != null) {
                            if (ref.getObjectId().getName().equals(commitId)) {
                                return checkoutEntry.getToBranch();
                            }
                            ref = repository.peel(ref);
                        }
                        if (ref == null || (id = ref.getPeeledObjectId()) == null || !id.getName().equals(commitId)) continue;
                        return checkoutEntry.getToBranch();
                    }
                }
            }
            catch (IOException iOException) {}
            Map<String, String> cacheEntry = this.commitMappingCache.get(repository.getDirectory().toString());
            if (!refresh && cacheEntry != null && cacheEntry.containsKey(commitId)) {
                return cacheEntry.get(commitId);
            }
            if (cacheEntry == null) {
                cacheEntry = new HashMap<String, String>();
                this.commitMappingCache.put(repository.getDirectory().getPath(), cacheEntry);
            } else {
                cacheEntry.clear();
            }
            HashMap<String, Date> tagMap = new HashMap<String, Date>();
            try {
                Object entry;
                entry = null;
                Iterator iterator = null;
                try (RevWalk revWalk = new RevWalk(repository);){
                    Map tags = repository.getRefDatabase().getRefs("refs/tags/");
                    for (Ref tagRef : tags.values()) {
                        RevCommit commit;
                        RevObject any = revWalk.parseAny((AnyObjectId)repository.resolve(tagRef.getName()));
                        if (any instanceof RevTag) {
                            Date timestamp;
                            RevTag tag = (RevTag)any;
                            if (!tag.getObject().name().equals(commitId)) continue;
                            if (tag.getTaggerIdent() != null) {
                                timestamp = tag.getTaggerIdent().getWhen();
                            } else {
                                try {
                                    RevCommit commit2 = revWalk.parseCommit((AnyObjectId)tag.getObject());
                                    timestamp = commit2.getCommitterIdent().getWhen();
                                }
                                catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                                    timestamp = null;
                                }
                            }
                            tagMap.put(tagRef.getName(), timestamp);
                            continue;
                        }
                        if (!(any instanceof RevCommit) || !(commit = (RevCommit)any).name().equals(commitId)) continue;
                        tagMap.put(tagRef.getName(), commit.getCommitterIdent().getWhen());
                    }
                }
                catch (Throwable throwable) {
                    if (entry == null) {
                        entry = throwable;
                    } else if (entry != throwable) {
                        ((Throwable)entry).addSuppressed(throwable);
                    }
                    throw entry;
                }
            }
            catch (IOException iOException) {}
            String cacheValue = null;
            if (!tagMap.isEmpty()) {
                Date compareDate = new Date(0L);
                for (Map.Entry entry : tagMap.entrySet()) {
                    if (entry.getValue() == null || !((Date)entry.getValue()).after(compareDate)) continue;
                    compareDate = (Date)entry.getValue();
                    cacheValue = (String)entry.getKey();
                }
                if (cacheValue == null) {
                    String string = "";
                    for (String tagName : tagMap.keySet()) {
                        void var9_17;
                        if (tagName.compareTo((String)var9_17) < 0) continue;
                        cacheValue = tagName;
                        String string2 = tagName;
                    }
                }
            }
            if (cacheValue == null) {
                branchNames = new TreeSet<String>();
                try {
                    Map map2 = repository.getRefDatabase().getRefs("refs/heads/");
                    for (Ref branch : map2.values()) {
                        if (!branch.getObjectId().name().equals(commitId)) continue;
                        branchNames.add(branch.getName());
                    }
                }
                catch (IOException iOException) {}
                if (!branchNames.isEmpty()) {
                    cacheValue = branchNames.toArray(new String[branchNames.size()])[branchNames.size() - 1];
                }
            }
            if (cacheValue == null) {
                branchNames = new TreeSet();
                try {
                    Map map3 = repository.getRefDatabase().getRefs("refs/remotes/");
                    for (Ref branch : map3.values()) {
                        if (!branch.getObjectId().name().equals(commitId)) continue;
                        branchNames.add(branch.getName());
                    }
                    if (!branchNames.isEmpty()) {
                        cacheValue = branchNames.toArray(new String[branchNames.size()])[branchNames.size() - 1];
                    }
                }
                catch (IOException iOException) {}
            }
            cacheEntry.put(commitId, cacheValue);
            return cacheValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryName(Repository repository) {
        File dir = !repository.isBare() ? repository.getWorkTree() : repository.getDirectory();
        if (dir == null) {
            return "";
        }
        Map<String, String> map = this.repositoryNameCache;
        synchronized (map) {
            String path = dir.getPath().toString();
            String name = this.repositoryNameCache.get(path);
            if (name != null) {
                return name;
            }
            name = dir.getName();
            this.repositoryNameCache.put(path, name);
            return name;
        }
    }

    public IEclipsePreferences getPreferences() {
        return this.prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRepositories() {
        String dirs;
        IEclipsePreferences iEclipsePreferences = this.prefs;
        synchronized (iEclipsePreferences) {
            dirs = this.prefs.get(PREFS_DIRECTORIES, "");
        }
        if (dirs == null || dirs.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> configuredStrings = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(dirs, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            configuredStrings.add(tok.nextToken());
        }
        return configuredStrings;
    }

    public List<String> getConfiguredRepositories() {
        ArrayList<String> repos = new ArrayList<String>(this.getRepositories());
        Collections.sort(repos);
        return repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConfiguredRepository(File repositoryDir) throws IllegalArgumentException {
        IEclipsePreferences iEclipsePreferences = this.prefs;
        synchronized (iEclipsePreferences) {
            List<String> dirStrings;
            String dirString;
            block5: {
                if (!RepositoryCache.FileKey.isGitRepository((File)repositoryDir, (FS)FS.DETECTED)) {
                    throw new IllegalArgumentException(MessageFormat.format(CoreText.RepositoryUtil_DirectoryIsNotGitDirectory, repositoryDir));
                }
                dirString = repositoryDir.getAbsolutePath();
                dirStrings = this.getConfiguredRepositories();
                if (!dirStrings.contains(dirString)) break block5;
                return false;
            }
            HashSet<String> dirs = new HashSet<String>();
            dirs.addAll(dirStrings);
            dirs.add(dirString);
            this.saveDirs(dirs);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDir(File file) {
        IEclipsePreferences iEclipsePreferences = this.prefs;
        synchronized (iEclipsePreferences) {
            block4: {
                String dirString = file.getAbsolutePath();
                HashSet<String> dirStrings = new HashSet<String>();
                dirStrings.addAll(this.getConfiguredRepositories());
                if (!dirStrings.remove(dirString)) break block4;
                this.saveDirs(dirStrings);
                return true;
            }
            return false;
        }
    }

    private void saveDirs(Set<String> gitDirStrings) {
        StringBuilder sb = new StringBuilder();
        for (String gitDirString : gitDirStrings) {
            sb.append(gitDirString);
            sb.append(File.pathSeparatorChar);
        }
        this.prefs.put(PREFS_DIRECTORIES, sb.toString());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            Status error = new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)error);
        }
    }

    public boolean contains(Repository repository) {
        return this.contains(repository.getDirectory().getAbsolutePath());
    }

    public boolean contains(String repositoryDir) {
        return this.getRepositories().contains(repositoryDir);
    }

    public String getShortBranch(Repository repository) throws IOException {
        Ref head = repository.getRef("HEAD");
        if (head == null || head.getObjectId() == null) {
            return CoreText.RepositoryUtil_noHead;
        }
        if (head.isSymbolic()) {
            return repository.getBranch();
        }
        String id = head.getObjectId().name();
        String ref = this.mapCommitToRef(repository, id, false);
        if (ref != null) {
            return String.valueOf(Repository.shortenRefName((String)ref)) + ' ' + id.substring(0, 7);
        }
        return id.substring(0, 7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit parseHeadCommit(Repository repository) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                RevWalk walk = new RevWalk(repository);
                try {
                    Ref head = repository.getRef("HEAD");
                    if (head == null) return null;
                    if (head.getObjectId() == null) {
                        return null;
                    }
                    RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
                    return commit;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (walk == null) return null;
                    walk.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isIgnored(IPath path) throws IOException {
        mapping = RepositoryMapping.getMapping(path);
        if (mapping == null) {
            return true;
        }
        repository = mapping.getRepository();
        treeIterator = IteratorService.createInitialIterator(repository);
        if (treeIterator == null) {
            return true;
        }
        repoRelativePath = mapping.getRepoRelativePath(path);
        var5_5 = null;
        var6_7 = null;
        try {
            walk = new TreeWalk(repository);
            try {
                walk.addTree((AbstractTreeIterator)treeIterator);
                walk.setFilter((TreeFilter)PathFilter.create((String)repoRelativePath));
                while (true) {
                    workingTreeIterator = (WorkingTreeIterator)walk.getTree(0, WorkingTreeIterator.class);
                    if (walk.getPathString().equals(repoRelativePath)) {
                        return workingTreeIterator.isEntryIgnored();
                    }
                    if (workingTreeIterator.getEntryFileMode().equals(FileMode.TREE)) {
                        walk.enterSubtree();
                    }
                    break;
                }
            }
            finally {
                if (walk.next()) ** continue;
            }
        }
        catch (Throwable var6_8) {
            if (var5_5 == null) {
                var5_5 = var6_8;
            } else if (var5_5 != var6_8) {
                var5_5.addSuppressed(var6_8);
            }
            throw var5_5;
        }
        return false;
    }

    public static boolean isDetachedHead(Repository repository) {
        try {
            return ObjectId.isId((String)repository.getFullBranch());
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return false;
        }
    }
}

