/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.action.NewPluginProjectDropDownAction;
import com.liferay.ide.project.ui.action.NewWizardAction;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class NewElementWizardAction
extends NewWizardAction {
    protected String validProjectTypes = null;

    public NewElementWizardAction(IConfigurationElement element) {
        super(element);
        this.setValidProjectTypes(this.getValidProjectTypesFromConfig(this.fConfigurationElement));
    }

    public String getValidProjectTypes() {
        return this.validProjectTypes;
    }

    private String getValidProjectTypesFromConfig(IConfigurationElement config) {
        IConfigurationElement[] classElements = config.getChildren();
        if (classElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = classElements;
            int n = classElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] paramElements;
                IConfigurationElement classElement = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren("parameter");
                int n3 = paramElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                    if ("validProjectTypes".equals(paramElement.getAttribute("name"))) {
                        return paramElement.getAttribute("value");
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void run() {
        IProject[] projects = CoreUtil.getAllProjects();
        boolean hasValidProjectTypes = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isLiferayFacetedProject((IProject)project)) {
                Set facets = ProjectUtil.getFacetedProject((IProject)project).getProjectFacets();
                if (this.validProjectTypes != null && facets != null) {
                    String[] validTypes;
                    String[] stringArray = validTypes = this.validProjectTypes.split(",");
                    int n3 = validTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String validProjectType = stringArray[n4];
                        for (IProjectFacetVersion facet : facets) {
                            String id = facet.getProjectFacet().getId();
                            if (!id.startsWith("liferay.") || !id.equals("liferay." + validProjectType)) continue;
                            hasValidProjectTypes = true;
                            break;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (hasValidProjectTypes) {
            super.run();
        } else {
            NewWizardAction[] actions;
            Shell shell = this.getShell();
            Boolean openNewLiferayProjectWizard = MessageDialog.openQuestion((Shell)shell, (String)Msgs.newElement, (String)Msgs.noSuitableLiferayProjects);
            if (openNewLiferayProjectWizard.booleanValue() && (actions = NewPluginProjectDropDownAction.getNewProjectActions()).length > 0) {
                actions[0].run();
                this.run();
            }
        }
    }

    public void setValidProjectTypes(String validProjectTypes) {
        this.validProjectTypes = validProjectTypes;
    }

    private static class Msgs
    extends NLS {
        public static String newElement;
        public static String noSuitableLiferayProjects;

        static {
            Msgs.initializeMessages((String)NewElementWizardAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

