/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Migration;
import com.liferay.blade.api.Problem;
import com.liferay.blade.api.ProgressMonitor;
import com.liferay.ide.core.util.MarkerUtil;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.core.upgrade.FileProblemsUtil;
import com.liferay.ide.project.core.upgrade.MigrationProblems;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.ProjectUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class MigrateProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                project = (IProject)adaptable.getAdapter(IProject.class);
            }
            if (project != null) {
                if (this.shouldShowMessageDialog(project)) {
                    boolean shouldContinue = this.showMessageDialog(project);
                    if (!shouldContinue) {
                        return null;
                    }
                    MarkerUtil.clearMarkers((IResource)project, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
                }
                IPath location = project.getLocation();
                this.findMigrationProblems(new IPath[]{location}, project.getName());
            }
        }
        return null;
    }

    public void findMigrationProblems(IPath[] locations) {
        this.findMigrationProblems(locations, "");
    }

    public void findMigrationProblems(final IPath[] locations, final String projectName) {
        WorkspaceJob job = new WorkspaceJob("Finding migration problems..."){

            public IStatus runInWorkspace(final IProgressMonitor monitor) throws CoreException {
                IStatus retval = Status.OK_STATUS;
                BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                ProgressMonitor override = new ProgressMonitor(){

                    public void worked(int work) {
                        monitor.worked(work);
                    }

                    public void setTaskName(String taskName) {
                        monitor.setTaskName(taskName);
                    }

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }

                    public void done() {
                        monitor.done();
                    }

                    public void beginTask(String taskName, int totalWork) {
                        monitor.beginTask(taskName, totalWork);
                    }
                };
                try {
                    ServiceReference sr = context.getServiceReference(Migration.class);
                    Migration m = (Migration)context.getService(sr);
                    ArrayList allProblems = new ArrayList();
                    IPath[] iPathArray = locations;
                    int n = locations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath location = iPathArray[n2];
                        if (!override.isCanceled()) {
                            List problems = m.findProblems(location.toFile(), override);
                            allProblems.addAll(problems);
                        }
                        ++n2;
                    }
                    if (allProblems.size() > 0) {
                        MigrationProblems migrationProblems = new MigrationProblems();
                        List fileProblemsList = FileProblemsUtil.newFileProblemsListFrom((Problem[])allProblems.toArray(new Problem[0]));
                        migrationProblems.setProblems(fileProblemsList.toArray(new FileProblems[0]));
                        migrationProblems.setType("Code Problems");
                        migrationProblems.setSuffix(projectName);
                        if (!projectName.equals("")) {
                            UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblems.class, (String)projectName, (Object)migrationProblems);
                        } else {
                            UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblems.class, (Object)migrationProblems);
                        }
                        m.reportProblems(allProblems, 4, "ide", new Object[0]);
                    }
                }
                catch (Exception e) {
                    retval = ProjectUI.createErrorStatus("Error in migrate command", e);
                }
                return retval;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().showInDialog(Display.getDefault().getActiveShell(), (Job)job);
        }
        catch (Exception exception) {}
        job.schedule();
    }

    private boolean showMessageDialog(IProject project) {
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        return MessageDialog.openConfirm((Shell)shell, (String)"Migrate Liferay Plugin", (String)"This project already contains migration problem markers.  All existing markers will be deleted.  Do you want to continue to run migration tool?");
    }

    private boolean shouldShowMessageDialog(IProject project) {
        IMarker[] markers = MarkerUtil.findMarkers((IResource)project, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
        return markers != null && markers.length > 0;
    }
}

