/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.blade.api.Command;
import com.liferay.blade.api.CommandException;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.ui.dialog.LiferayProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.AbstractOSGiCommandHandler;
import com.liferay.ide.ui.WorkspaceHelper;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ConvertJspHookFragmentsHandler
extends AbstractOSGiCommandHandler {
    public ConvertJspHookFragmentsHandler() {
        super("ConvertJspHook");
    }

    @Override
    protected Object execute(ExecutionEvent event, Command command) throws ExecutionException {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IJavaProject project;
                return element instanceof IJavaProject && CoreUtil.isLiferayProject((IProject)(project = (IJavaProject)element).getProject());
            }
        };
        LiferayProjectSelectionDialog dialog = new LiferayProjectSelectionDialog(UIUtil.getActiveShell(), filter);
        dialog.open();
        Object[] projects = dialog.getResult();
        if (projects != null && projects.length > 0) {
            IJavaProject javaProject = (IJavaProject)projects[0];
            File srcDir = javaProject.getProject().getLocation().toFile();
            File destDir = javaProject.getProject().getLocation().removeLastSegments(2).append("modules").append(String.valueOf(srcDir.getName()) + "-module").toFile();
            destDir.mkdirs();
            HashMap<String, File> parameters = new HashMap<String, File>();
            parameters.put("sourcePath", srcDir);
            parameters.put("targetPath", destDir);
            try {
                command.execute(parameters);
                new WorkspaceHelper().openDir(destDir.getAbsolutePath());
            }
            catch (CommandException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

