/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.LiferaySDKField;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public class SDKProjectsImportWizardPage
extends DataModelFacetCreationWizardPage
implements ISDKProjectsImportDataModelProperties {
    protected Label labelProjectsList;
    protected long lastModified;
    protected String lastPath;
    protected CheckboxTreeViewer projectsList;
    protected Text sdkLocation;
    protected Text sdkVersion;
    protected Object[] selectedProjects = new ProjectRecord[0];
    protected Combo serverTargetCombo;
    protected IProject[] wsProjects;

    public SDKProjectsImportWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(Msgs.importLiferayProjects);
        this.setDescription(Msgs.selectLiferayPluginSDK);
    }

    protected void createPluginsSDKField(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.synchHelper.synchAllUIWithModel();
                SDKProjectsImportWizardPage.this.updateProjectsList(SDKProjectsImportWizardPage.this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION"));
                SDKProjectsImportWizardPage.this.validatePage(true);
            }
        };
        new LiferaySDKField(parent, this.getDataModel(), selectionAdapter, "ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME", this.synchHelper);
    }

    protected void createProjectsList(Composite workArea) {
        this.labelProjectsList = new Label(workArea, 0);
        this.labelProjectsList.setText(Msgs.importProjectsLabel);
        this.labelProjectsList.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.projectsList = new CheckboxTreeViewer(workArea, 2048);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return SDKProjectsImportWizardPage.this.getProjectRecords();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider(this.createProjectsListLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SDKProjectsImportWizardPage.this.handleCheckStateChangedEvent(event);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(workArea);
    }

    protected IBaseLabelProvider createProjectsListLabelProvider() {
        return new ProjectLabelProvider();
    }

    protected void createSDKLocationField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)Msgs.liferayPluginSDKLocationLabel, (int)1);
        this.sdkLocation = SWTUtil.createText((Composite)topComposite, (int)1);
        ((GridData)this.sdkLocation.getLayoutData()).widthHint = 300;
        this.synchHelper.synchText(this.sdkLocation, "ISDKProjectsImportDataModelProperties.SDK_LOCATION", null);
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"", (int)1);
    }

    protected void createSDKVersionField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)Msgs.liferayPluginSDKVersionLabel, (int)1);
        this.sdkVersion = SWTUtil.createText((Composite)topComposite, (int)1);
        this.synchHelper.synchText(this.sdkVersion, "ISDKProjectsImportDataModelProperties.SDK_VERSION", null);
        SWTUtil.createLabel((Composite)topComposite, (String)"", (int)1);
    }

    protected void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(Msgs.selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.handleSelectAll(e);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(Msgs.deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.handleDeselectAll(e);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(Msgs.refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.handleRefresh(e);
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    protected void createTargetRuntimeGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Msgs.liferayTargetRuntimeLabel);
        label.setLayoutData((Object)new GridData(32));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText(Msgs.newButton);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = SDKProjectsImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)SDKProjectsImportWizardPage.this.getShell(), (String)SDKProjectsImportWizardPage.this.getModuleTypeID(), null, (String)"com.liferay.");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = SDKProjectsImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        SDKProjectsImportWizardPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        GridLayout gl = new GridLayout(3, false);
        topComposite.setLayout((Layout)gl);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createPluginsSDKField(topComposite);
        SWTUtil.createSeparator((Composite)topComposite, (int)3);
        this.createSDKLocationField(topComposite);
        this.createSDKVersionField(topComposite);
        SWTUtil.createVerticalSpacer((Composite)topComposite, (int)1, (int)3);
        this.createProjectsList(topComposite);
        this.createTargetRuntimeGroup(topComposite);
        return topComposite;
    }

    protected void enter() {
        SDK initialSdk;
        String sdkName = this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME");
        if (sdkName != null && (initialSdk = SDKManager.getInstance().getSDK(sdkName)) != null) {
            this.updateProjectsList(initialSdk.getLocation().toOSString());
        }
    }

    public Object[] getProjectRecords() {
        ArrayList<Object> projectRecords = new ArrayList<Object>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            ProjectRecord projectRecord = (ProjectRecord)this.selectedProjects[i];
            if (this.isProjectInWorkspace(projectRecord.getProjectName())) {
                projectRecord.setHasConflicts(true);
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    protected IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"ISDKProjectsImportDataModelProperties.SDK_LOCATION", "ISDKProjectsImportDataModelProperties.SDK_VERSION", "ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME"};
    }

    protected void handleCheckStateChangedEvent(CheckStateChangedEvent event) {
        ProjectRecord element = (ProjectRecord)event.getElement();
        if (element.hasConflicts()) {
            this.projectsList.setChecked((Object)element, false);
        }
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    protected void handleDeselectAll(SelectionEvent e) {
        this.projectsList.setCheckedElements(new Object[0]);
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.validatePage(true);
        this.setPageComplete(false);
    }

    protected void handleFileBrowseButton(Text text) {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setText(Msgs.selectLiferayPluginSDKFolder);
        if (!CoreUtil.isNullOrEmpty((String)this.sdkLocation.getText())) {
            dd.setFilterPath(this.sdkLocation.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            this.sdkLocation.setText(dir);
            this.updateProjectsList(dir);
            this.synchHelper.synchAllUIWithModel();
            this.validatePage();
        }
    }

    protected void handleRefresh(SelectionEvent e) {
        this.lastModified = -1L;
        this.updateProjectsList(this.sdkLocation.getText().trim());
        this.projectsList.setCheckedElements(new Object[0]);
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
    }

    protected void handleSelectAll(SelectionEvent e) {
        int i = 0;
        while (i < this.selectedProjects.length) {
            ProjectRecord projectRecord = (ProjectRecord)this.selectedProjects[i];
            if (projectRecord.hasConflicts()) {
                this.projectsList.setChecked((Object)projectRecord, false);
            } else {
                this.projectsList.setChecked((Object)projectRecord, true);
            }
            ++i;
        }
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.validatePage(true);
    }

    protected boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public void updateProjectsList(String path) {
        Object[] checkedProjects;
        if (path == null || path.length() == 0) {
            this.setMessage(Msgs.importProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements(this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Msgs.searchingMessage, 100);
                    SDKProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList eclipseProjectFiles = new ArrayList();
                    ArrayList liferayProjectDirs = new ArrayList();
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        if (!ProjectUtil.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, (File)directory, null, (boolean)true, (IProgressMonitor)monitor)) {
                            return;
                        }
                        SDKProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[eclipseProjectFiles.size() + liferayProjectDirs.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(Msgs.processingMessage);
                        for (File eclipseProjectFile : eclipseProjectFiles) {
                            SDKProjectsImportWizardPage.this.selectedProjects[index++] = new ProjectRecord(eclipseProjectFile);
                        }
                        for (File liferayProjectDir : liferayProjectDirs) {
                            SDKProjectsImportWizardPage.this.selectedProjects[index++] = new ProjectRecord(liferayProjectDir);
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ProjectUI.logError(e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        Object[] projects = this.getProjectRecords();
        boolean displayWarning = false;
        int i = 0;
        while (i < projects.length) {
            ProjectRecord projectRecord = (ProjectRecord)projects[i];
            if (projectRecord.hasConflicts()) {
                displayWarning = true;
                this.projectsList.setGrayed(projects[i], true);
            }
            ++i;
        }
        if (displayWarning) {
            this.setMessage(Msgs.projectsInWorkspace, 2);
        } else {
            this.setMessage(Msgs.importProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(Msgs.noProjectsToImport, 2);
        }
        if ((checkedProjects = this.projectsList.getCheckedElements()) != null && checkedProjects.length > 0) {
            this.selectedProjects = new ProjectRecord[checkedProjects.length];
            int i2 = 0;
            while (i2 < checkedProjects.length) {
                this.selectedProjects[i2] = (ProjectRecord)checkedProjects[i2];
                ++i2;
            }
            this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.selectedProjects);
        }
    }

    private static class Msgs
    extends NLS {
        public static String deselectAll;
        public static String importLiferayProjects;
        public static String importProjectsDescription;
        public static String importProjectsLabel;
        public static String liferayPluginSDKLocationLabel;
        public static String liferayPluginSDKVersionLabel;
        public static String liferayTargetRuntimeLabel;
        public static String newButton;
        public static String noProjectsToImport;
        public static String processingMessage;
        public static String projectsInWorkspace;
        public static String refresh;
        public static String searchingMessage;
        public static String selectAll;
        public static String selectLiferayPluginSDK;
        public static String selectLiferayPluginSDKFolder;

        static {
            Msgs.initializeMessages((String)SDKProjectsImportWizardPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    protected final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        protected ProjectLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts()) {
                return SDKProjectsImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }

        public String getText(Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }
    }
}

