/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRegistryReader {
    private static final Logger log = LoggerFactory.getLogger(ProjectRegistryReader.class);
    private static final String WORKSPACE_STATE = "workspaceState.ser";
    private final File stateFile;
    private static PackageAdmin packageAdmin;

    public ProjectRegistryReader(File stateLocationDir) {
        this.stateFile = new File(stateLocationDir, WORKSPACE_STATE);
    }

    public ProjectRegistry readWorkspaceState(final ProjectRegistryManager managerImpl) {
        if (this.stateFile.exists()) {
            final PackageAdmin packageAdmin = ProjectRegistryReader.getPackageAdmin();
            ObjectInputStream is = null;
            try {
                is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.stateFile))){
                    {
                        super($anonymous0);
                        this.enableResolveObject(true);
                    }

                    @Override
                    protected Object resolveObject(Object o) throws IOException {
                        if (o instanceof IPathReplace) {
                            return ((IPathReplace)o).getPath();
                        }
                        if (o instanceof IFileReplace) {
                            return ((IFileReplace)o).getFile();
                        }
                        if (o instanceof MavenProjectManagerImplReplace) {
                            return managerImpl;
                        }
                        return super.resolveObject(o);
                    }

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        String symbolicName = (String)this.readObject();
                        if (symbolicName == null) {
                            return super.resolveClass(desc);
                        }
                        String versionStr = (String)this.readObject();
                        Version version = Version.parseVersion((String)versionStr);
                        VersionRange versionRange = new VersionRange(version, true, version, true);
                        Bundle[] bundles = packageAdmin.getBundles(symbolicName, versionRange.toString());
                        if (bundles == null || bundles.length != 1) {
                            throw new ClassNotFoundException("Could not find bundle " + symbolicName + "/" + version + " required to load class " + desc.getName());
                        }
                        return bundles[0].loadClass(desc.getName());
                    }
                };
                ProjectRegistry projectRegistry = (ProjectRegistry)is.readObject();
                IOUtil.close((InputStream)is);
                return projectRegistry;
            }
            catch (Exception ex) {
                log.error("Can't read workspace state", (Throwable)ex);
            }
            finally {
                IOUtil.close(is);
            }
        }
        return null;
    }

    private static synchronized PackageAdmin getPackageAdmin() {
        if (packageAdmin == null) {
            BundleContext context = MavenPluginActivator.getDefault().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(PackageAdmin.class.getName());
            packageAdmin = (PackageAdmin)context.getService(serviceReference);
        }
        return packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWorkspaceState(ProjectRegistry state) {
        block8: {
            final ClassLoader thisClassloader = this.getClass().getClassLoader();
            final PackageAdmin packageAdmin = ProjectRegistryReader.getPackageAdmin();
            ObjectOutputStream os = null;
            try {
                try {
                    os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.stateFile))){
                        {
                            super($anonymous0);
                            this.enableReplaceObject(true);
                        }

                        @Override
                        protected Object replaceObject(Object o) throws IOException {
                            if (o instanceof IPath) {
                                return new IPathReplace((IPath)o);
                            }
                            if (o instanceof IFile) {
                                return new IFileReplace((IFile)o);
                            }
                            if (o instanceof ProjectRegistryManager) {
                                return new MavenProjectManagerImplReplace();
                            }
                            return super.replaceObject(o);
                        }

                        @Override
                        protected void annotateClass(Class<?> cl) throws IOException {
                            try {
                                Class<?> target = cl;
                                while (target.isArray()) {
                                    target = target.getComponentType();
                                }
                                if (target.isPrimitive() || target.equals(thisClassloader.loadClass(target.getName()))) {
                                    this.writeObject(null);
                                    return;
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                            Bundle bundle = packageAdmin.getBundle(cl);
                            if (bundle != null) {
                                this.writeObject(bundle.getSymbolicName());
                                this.writeObject(bundle.getVersion().toString());
                            }
                        }
                    };
                    ProjectRegistry projectRegistry = state;
                    synchronized (projectRegistry) {
                        os.writeObject(state);
                    }
                }
                catch (Exception ex) {
                    log.error("Can't write workspace state", (Throwable)ex);
                    IOUtil.close(os);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
            IOUtil.close((OutputStream)os);
        }
    }

    private static final class IFileReplace
    implements Serializable {
        private static final long serialVersionUID = -7266001068347075329L;
        private final String path;

        public IFileReplace(IFile file) {
            this.path = file.getFullPath().toPortableString();
        }

        public IFile getFile() {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.getFile(Path.fromPortableString((String)this.path));
        }
    }

    private static final class IPathReplace
    implements Serializable {
        private static final long serialVersionUID = -2361259525684491181L;
        private final String path;

        public IPathReplace(IPath path) {
            this.path = path.toPortableString();
        }

        public IPath getPath() {
            return Path.fromPortableString((String)this.path);
        }
    }

    static final class MavenProjectManagerImplReplace
    implements Serializable {
        private static final long serialVersionUID = 1995671440438776471L;

        MavenProjectManagerImplReplace() {
        }
    }
}

