/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.ui.LiferayUIPlugin;
import com.liferay.ide.ui.util.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class LiferayLanguagePropertiesMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<EncodeOneFileToDefaultResolution> resolutions = new ArrayList<EncodeOneFileToDefaultResolution>();
        try {
            if ("language-properties-encoding-not-defalut".equals(marker.getAttribute("sourceId"))) {
                resolutions.add(new EncodeAllFilesToDefaultResolution());
                resolutions.add(new EncodeOneFileToDefaultResolution(null, null));
            }
        }
        catch (CoreException e) {
            LiferayUIPlugin.logError((Exception)((Object)e));
        }
        return resolutions.toArray(new IMarkerResolution[0]);
    }

    public boolean hasResolutions(IMarker marker) {
        try {
            if ("com.liferay.ide.core.LiferayLanguagePropertiesMarker".equals(marker.getType()) && "language-properties-encoding-not-defalut".equals(marker.getAttribute("sourceId"))) {
                return true;
            }
        }
        catch (CoreException e) {
            LiferayUIPlugin.logError((Exception)((Object)e));
        }
        return false;
    }

    private class EncodeAllFilesToDefaultResolution
    extends EncodeOneFileToDefaultResolution {
        private EncodeAllFilesToDefaultResolution() {
        }

        @Override
        public String getLabel() {
            return Msgs.encodeAllFilesToDefault;
        }

        @Override
        public void run(IMarker marker) {
            this.encode((IResource)CoreUtil.getLiferayProject((IResource)marker.getResource()));
        }
    }

    private class EncodeOneFileToDefaultResolution
    implements IMarkerResolution2 {
        private EncodeOneFileToDefaultResolution() {
        }

        public String getDescription() {
            return this.getLabel();
        }

        public Image getImage() {
            URL url = LiferayUIPlugin.getDefault().getBundle().getEntry("/icons/e16/encode.png");
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }

        public String getLabel() {
            return Msgs.encodeThisFileToDefault;
        }

        public void run(IMarker marker) {
            if (marker.getResource().getType() == 1) {
                this.encode((IResource)((IFile)marker.getResource()));
            }
        }

        protected void encode(final IResource resource) {
            if (resource != null && resource.exists()) {
                try {
                    new ProgressMonitorDialog(UIUtil.getActiveShell()).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Encoding Liferay language properties files to default (UTF-8)... ", 10);
                            PropertiesUtil.encodeLanguagePropertiesFilesToDefault((IResource)resource, (IProgressMonitor)monitor);
                            monitor.done();
                        }
                    });
                }
                catch (Exception e) {
                    LiferayUIPlugin.logError(e);
                }
            }
        }

        /* synthetic */ EncodeOneFileToDefaultResolution(EncodeOneFileToDefaultResolution encodeOneFileToDefaultResolution, EncodeOneFileToDefaultResolution encodeOneFileToDefaultResolution2) {
            this();
        }
    }

    private static class Msgs
    extends NLS {
        public static String encodeThisFileToDefault;
        public static String encodeAllFilesToDefault;

        static {
            Msgs.initializeMessages((String)LiferayLanguagePropertiesMarkerResolutionGenerator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

