/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui;

import com.liferay.ide.server.core.ILiferayServerWorkingCopy;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.remote.IRemoteServer;
import com.liferay.ide.server.remote.IRemoteServerWorkingCopy;
import com.liferay.ide.server.remote.RemoteServer;
import com.liferay.ide.server.ui.cmd.SetAdjustDeploymentTimestampCommand;
import com.liferay.ide.server.ui.cmd.SetHttpPortCommand;
import com.liferay.ide.server.ui.cmd.SetLiferayPortalContextPathCommand;
import com.liferay.ide.server.ui.cmd.SetPasswordCommand;
import com.liferay.ide.server.ui.cmd.SetServerManagerContextPathCommand;
import com.liferay.ide.server.ui.cmd.SetUsernameCommand;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class RemoteSettingsEditorSection
extends ServerEditorSection {
    protected Button adjustTimestamp;
    protected PropertyChangeListener listener;
    protected RemoteServer remoteServer;
    protected Section remoteSettings;
    protected Text textHttpPort;
    protected Text textLiferayPortalContextPath;
    protected Text textPassword;
    protected Text textServerManagerContextPath;
    protected Text textUsername;
    protected boolean updating = false;

    public void createSection(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.remoteSettings = this.createSettingsSection(parent, toolkit);
        this.remoteSettings.setText(Msgs.remoteLiferaySettings);
        this.remoteSettings.setLayoutData((Object)new GridData(784));
        this.remoteSettings.setDescription(Msgs.specifySettings);
        Composite settingsComposite = this.createSectionComposite(toolkit, this.remoteSettings);
        Label soapPortLabel = this.createLabel(toolkit, settingsComposite, Msgs.httpPortLabel);
        soapPortLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textHttpPort = toolkit.createText(settingsComposite, null);
        GridData data = new GridData(4, 128, true, false);
        data.widthHint = 50;
        this.textHttpPort.setLayoutData((Object)data);
        this.textHttpPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                RemoteSettingsEditorSection.this.execute((IUndoableOperation)new SetHttpPortCommand((IRemoteServerWorkingCopy)RemoteSettingsEditorSection.this.remoteServer, RemoteSettingsEditorSection.this.textHttpPort.getText().trim()));
                RemoteSettingsEditorSection.this.updating = false;
            }
        });
        Label usernameLabel = this.createLabel(toolkit, settingsComposite, Msgs.username);
        usernameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textUsername = toolkit.createText(settingsComposite, null);
        this.textUsername.setLayoutData((Object)new GridData(4, 128, true, false));
        this.textUsername.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                RemoteSettingsEditorSection.this.execute((IUndoableOperation)new SetUsernameCommand((ILiferayServerWorkingCopy)RemoteSettingsEditorSection.this.remoteServer, RemoteSettingsEditorSection.this.textUsername.getText().trim()));
                RemoteSettingsEditorSection.this.updating = false;
            }
        });
        Label passwordLabel = this.createLabel(toolkit, settingsComposite, Msgs.passwordLabel);
        passwordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textPassword = toolkit.createText(settingsComposite, null, 0x400000);
        this.textPassword.setLayoutData((Object)new GridData(4, 128, true, false));
        this.textPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                RemoteSettingsEditorSection.this.execute((IUndoableOperation)new SetPasswordCommand((ILiferayServerWorkingCopy)RemoteSettingsEditorSection.this.remoteServer, RemoteSettingsEditorSection.this.textPassword.getText().trim()));
                RemoteSettingsEditorSection.this.updating = false;
            }
        });
        Label labelLiferayPortalContextPath = this.createLabel(toolkit, settingsComposite, Msgs.liferayPortalContextPathLabel);
        labelLiferayPortalContextPath.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textLiferayPortalContextPath = toolkit.createText(settingsComposite, null);
        this.textLiferayPortalContextPath.setLayoutData((Object)new GridData(4, 128, true, false));
        this.textLiferayPortalContextPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                RemoteSettingsEditorSection.this.execute((IUndoableOperation)new SetLiferayPortalContextPathCommand((IRemoteServerWorkingCopy)RemoteSettingsEditorSection.this.remoteServer, RemoteSettingsEditorSection.this.textLiferayPortalContextPath.getText().trim()));
                RemoteSettingsEditorSection.this.updating = false;
            }
        });
        Label labelServerManagerContextPath = this.createLabel(toolkit, settingsComposite, Msgs.serverManagerContextPathLabel);
        labelServerManagerContextPath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.textServerManagerContextPath = toolkit.createText(settingsComposite, null);
        this.textServerManagerContextPath.setLayoutData((Object)new GridData(4, 128, true, false));
        this.textServerManagerContextPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                RemoteSettingsEditorSection.this.execute((IUndoableOperation)new SetServerManagerContextPathCommand((IRemoteServerWorkingCopy)RemoteSettingsEditorSection.this.remoteServer, RemoteSettingsEditorSection.this.textServerManagerContextPath.getText().trim()));
                RemoteSettingsEditorSection.this.updating = false;
            }
        });
        this.adjustTimestamp = toolkit.createButton(settingsComposite, Msgs.adjustDeploymentTimestamps, 32);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.adjustTimestamp.setLayoutData((Object)gd);
        this.adjustTimestamp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                RemoteSettingsEditorSection.this.execute((IUndoableOperation)new SetAdjustDeploymentTimestampCommand((IRemoteServer)RemoteSettingsEditorSection.this.remoteServer, RemoteSettingsEditorSection.this.adjustTimestamp.getSelection()));
                RemoteSettingsEditorSection.this.updating = false;
            }
        });
        this.initialize();
        IStatus status = this.validateSection();
        if (!status.isOK()) {
            this.getManagedForm().getMessageManager().addMessage((Object)this.remoteServer, status.getMessage(), (Object)status, status.getSeverity() == 4 ? 3 : 2);
        }
    }

    public IStatus[] getSaveStatus() {
        IStatus status = this.validateSection();
        if (!status.isOK()) {
            this.getManagedForm().getMessageManager().addMessage((Object)this.remoteServer, status.getMessage(), (Object)status, status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.getManagedForm().getMessageManager().removeMessage((Object)this.remoteServer);
        }
        return new IStatus[]{Status.OK_STATUS};
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.remoteServer = (RemoteServer)this.server.loadAdapter(RemoteServer.class, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent event) {
                LiferayServerCore.updateConnectionSettings((IRemoteServer)RemoteSettingsEditorSection.this.remoteServer);
                if (RemoteSettingsEditorSection.this.updating) {
                    return;
                }
                RemoteSettingsEditorSection.this.updating = true;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ("adjust-deployment-timestamp".equals(event.getPropertyName())) {
                            String s = (String)event.getNewValue();
                            (this).RemoteSettingsEditorSection.this.adjustTimestamp.setSelection(Boolean.parseBoolean(s));
                        } else if ("username".equals(event.getPropertyName())) {
                            String s = (String)event.getNewValue();
                            (this).RemoteSettingsEditorSection.this.textUsername.setText(s);
                        } else if ("password".equals(event.getPropertyName())) {
                            String s = (String)event.getNewValue();
                            (this).RemoteSettingsEditorSection.this.textPassword.setText(s);
                        } else if ("http-port".equals(event.getPropertyName())) {
                            String s = (String)event.getNewValue();
                            (this).RemoteSettingsEditorSection.this.textHttpPort.setText(s);
                        } else if ("liferay-portal-context-path".equals(event.getPropertyName())) {
                            String s = (String)event.getNewValue();
                            (this).RemoteSettingsEditorSection.this.textLiferayPortalContextPath.setText(s);
                        } else if ("server-manager-context-path".equals(event.getPropertyName())) {
                            String s = (String)event.getNewValue();
                            (this).RemoteSettingsEditorSection.this.textServerManagerContextPath.setText(s);
                        }
                    }
                });
                RemoteSettingsEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    protected Composite createSectionComposite(FormToolkit toolkit, Section section) {
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        return composite;
    }

    protected Section createSettingsSection(Composite parent, FormToolkit toolkit) {
        return toolkit.createSection(parent, 458);
    }

    protected void initialize() {
        if (this.remoteServer == null || this.textHttpPort == null || this.adjustTimestamp == null || this.textUsername == null || this.textPassword == null || this.textLiferayPortalContextPath == null || this.textServerManagerContextPath == null) {
            return;
        }
        this.updating = true;
        this.textHttpPort.setText(this.remoteServer.getHTTPPort());
        this.textUsername.setText(this.remoteServer.getUsername());
        this.textPassword.setText(this.remoteServer.getPassword());
        this.textLiferayPortalContextPath.setText(this.remoteServer.getLiferayPortalContextPath());
        this.textServerManagerContextPath.setText(this.remoteServer.getServerManagerContextPath());
        boolean adjustGMTOffset = this.remoteServer.getAdjustDeploymentTimestamp();
        this.adjustTimestamp.setSelection(adjustGMTOffset);
        this.updating = false;
    }

    protected IStatus validateSection() {
        final IStatus[] status = new IStatus[1];
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    status[0] = RemoteSettingsEditorSection.this.remoteServer.validate(monitor);
                }
            });
        }
        catch (Exception exception) {}
        return status[0];
    }

    private static class Msgs
    extends NLS {
        public static String adjustDeploymentTimestamps;
        public static String httpPortLabel;
        public static String liferayPortalContextPathLabel;
        public static String passwordLabel;
        public static String remoteLiferaySettings;
        public static String serverManagerContextPathLabel;
        public static String specifySettings;
        public static String username;

        static {
            Msgs.initializeMessages((String)RemoteSettingsEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

