/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IServer;

public class CreateDBConnectAction
extends AbstractServerRunningAction {
    private static final String JDBC_DRIVER_CLASS_NAME = "jdbc.default.driverClassName";
    private static final String PORTAL_EXT_PROPERTIES = "portal-ext.properties";
    private static final String PORTAL_SETUP_PROPERTIES = "portal-setup-wizard.properties";

    private String generateUniqueConnectionProfileName(String connectionProfileName) {
        int index = 1;
        String testName = connectionProfileName;
        while (ProfileManager.getInstance().getProfileByName(testName) != null) {
            testName = String.valueOf(connectionProfileName) + String.valueOf(++index);
        }
        return testName;
    }

    private Properties getDatabaseProperties(IPath bundlePath) {
        IPath bundleExtPath = bundlePath.append(PORTAL_EXT_PROPERTIES);
        Properties pluginPackageProperties = new Properties();
        try {
            if (bundleExtPath.toFile().exists()) {
                IPath setupWizardPath;
                FileInputStream extInputStream = new FileInputStream(bundleExtPath.toFile());
                pluginPackageProperties.load(extInputStream);
                ((InputStream)extInputStream).close();
                String driverName = pluginPackageProperties.getProperty(JDBC_DRIVER_CLASS_NAME);
                if (CoreUtil.isNullOrEmpty((String)driverName) && (setupWizardPath = bundlePath.append(PORTAL_SETUP_PROPERTIES)).toFile().exists()) {
                    FileInputStream setupInputStream = new FileInputStream(setupWizardPath.toFile());
                    pluginPackageProperties.load(setupInputStream);
                    ((InputStream)setupInputStream).close();
                }
            } else {
                IPath setupWizardPath = bundlePath.append(PORTAL_SETUP_PROPERTIES);
                if (setupWizardPath.toFile().exists()) {
                    FileInputStream setupInputStream = new FileInputStream(setupWizardPath.toFile());
                    pluginPackageProperties.load(setupInputStream);
                    ((InputStream)setupInputStream).close();
                }
            }
        }
        catch (Exception extException) {
            LiferayServerCore.logError((String)Msgs.noDatabasePropertyFile, (Throwable)extException);
        }
        return pluginPackageProperties;
    }

    private LiferayDatabaseConnection getLiferayDBConnection(String driverClass, String userName, String password, String connectionUrl) {
        if (driverClass.equals("com.mysql.jdbc.Driver")) {
            return new MysqlLiferayDatabaseConnection("com.mysql.jdbc.Driver", "org.eclipse.datatools.enablement.mysql.connectionProfile", "Mysql Connection Profile", "org.eclipse.datatools.enablement.mysql.5_1.driverTemplate", userName, password, connectionUrl);
        }
        if (driverClass.equals("org.postgresql.Driver")) {
            return new PostgresqlLiferayDatabaseConnection("org.postgresql.Driver", "org.eclipse.datatools.enablement.postgresql.connectionProfile", "Posgresql Connection Profile", "org.eclipse.datatools.enablement.postgresql.postgresqlDriverTemplate", userName, password, connectionUrl);
        }
        if (driverClass == null || driverClass.equals("org.hsqldb.jdbcDriver")) {
            return new HsqlLiferayDatabaseConnection("org.hsqldb.jdbcDriver", "org.eclipse.datatools.enablement.hsqldb.connectionProfile", "Hsql Connection Profile", "org.eclipse.datatools.enablement.hsqldb.1_8.driver");
        }
        return null;
    }

    private URL[] getLiferayRuntimeLibs(ILiferayRuntime liferayRuntime) throws Exception {
        Object[] extraLibs = liferayRuntime.getUserLibs();
        ArrayList<URL> libUrlList = new ArrayList<URL>();
        if (!CoreUtil.isNullOrEmpty((Object[])extraLibs)) {
            Object[] objectArray = extraLibs;
            int n = extraLibs.length;
            int n2 = 0;
            while (n2 < n) {
                Object url = objectArray[n2];
                libUrlList.add(new File(url.toOSString()).toURI().toURL());
                ++n2;
            }
        }
        URL[] urls = libUrlList.toArray(new URL[libUrlList.size()]);
        return urls;
    }

    @Override
    protected int getRequiredServerState() {
        return 7;
    }

    public void run(IAction action) {
        if (this.selectedServer != null) {
            ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IServer)this.selectedServer);
            Properties pluginPackageProperties = this.getDatabaseProperties(liferayRuntime.getLiferayHome());
            final String driverName = pluginPackageProperties.getProperty(JDBC_DRIVER_CLASS_NAME, "org.hsqldb.jdbcDriver");
            final String connectionName = liferayRuntime.getRuntime().getName();
            final String userName = pluginPackageProperties.getProperty("jdbc.default.username");
            final String connectionUrl = pluginPackageProperties.getProperty("jdbc.default.url");
            final String password = pluginPackageProperties.getProperty("jdbc.default.password");
            try {
                final URL[] runtimeLibs = this.getLiferayRuntimeLibs(liferayRuntime);
                new Job(Msgs.addDBConnnection){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Class<?> classRef = new URLClassLoader(runtimeLibs).loadClass(driverName);
                            if (classRef != null) {
                                String libPath = classRef.getProtectionDomain().getCodeSource().getLocation().getPath();
                                String jarPath = URLDecoder.decode(libPath, "UTF-8");
                                String driverPath = new File(jarPath).getAbsolutePath();
                                LiferayDatabaseConnection dbConnection = CreateDBConnectAction.this.getLiferayDBConnection(driverName, userName, password, connectionUrl);
                                if (dbConnection != null) {
                                    dbConnection.addDatabaseConnectionProfile(connectionName, driverPath);
                                    UIUtil.async((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            IViewPart dbView = UIUtil.showView((String)"org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
                                            dbView.setFocus();
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception e) {
                            LiferayServerCore.logError((String)Msgs.addProfileError, (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (Exception e) {
                LiferayServerCore.logError((String)Msgs.noDBConnectDriver, (Throwable)e);
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        super.selectionChanged(action, selection);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).toList().size() > 1) {
            action.setEnabled(sel.toList().size() == 1);
        }
    }

    private class HsqlLiferayDatabaseConnection
    extends LiferayDatabaseConnection {
        private static final String defaultConnecionUrl = "jdbc:hsqldb:lportal";
        private static final String defaultPassword = "";
        private static final String defaultUserName = "sa";

        public HsqlLiferayDatabaseConnection(String driverClass, String providerId, String connectinDesc, String driverTemplate) {
            super(driverClass, providerId, connectinDesc, driverTemplate, defaultUserName, defaultPassword, defaultConnecionUrl);
        }

        @Override
        protected String getDatabaseName(String connectionUrl) {
            String databaseName;
            int databaseNameBegin;
            String retval = "lportal";
            if (!CoreUtil.isNullOrEmpty((String)connectionUrl) && (databaseNameBegin = connectionUrl.lastIndexOf("/")) > 0 && !CoreUtil.isNullOrEmpty((String)(databaseName = connectionUrl.substring(databaseNameBegin + 1)))) {
                retval = databaseName;
            }
            return retval;
        }
    }

    private abstract class LiferayDatabaseConnection {
        private String connectionDesc;
        private String connectionUrl;
        private String driverClass;
        private String driverTemplate;
        private String password;
        private String providerId;
        private String userName;

        public LiferayDatabaseConnection(String driverClass, String providerId, String connectinDesc, String driverTemplate, String userName, String password, String connectionUrl) {
            this.driverClass = driverClass;
            this.providerId = providerId;
            this.connectionDesc = connectinDesc;
            this.driverTemplate = driverTemplate;
            this.userName = userName;
            this.password = password;
            this.connectionUrl = connectionUrl;
        }

        public void addDatabaseConnectionProfile(String connectionName, String driverPath) throws ConnectionProfileException {
            String uniqueDriverInstanceName = this.generateUniqueDriverDefinitionName(connectionName);
            DriverInstance driverInstance = DriverManager.getInstance().createNewDriverInstance(this.driverTemplate, uniqueDriverInstanceName, driverPath, this.driverClass);
            String vendor = driverInstance.getProperty("org.eclipse.datatools.connectivity.db.vendor");
            String uniqueConnectionProfileName = CreateDBConnectAction.this.generateUniqueConnectionProfileName(String.valueOf(connectionName) + " " + vendor);
            Properties connectionProfileProperties = driverInstance.getPropertySet().getBaseProperties();
            connectionProfileProperties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverInstance.getId());
            connectionProfileProperties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.getDatabaseName(this.connectionUrl));
            connectionProfileProperties.setProperty("org.eclipse.datatools.connectivity.db.username", this.userName);
            connectionProfileProperties.setProperty("org.eclipse.datatools.connectivity.db.password", this.password);
            connectionProfileProperties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.connectionUrl);
            ProfileManager.getInstance().createProfile(uniqueConnectionProfileName, this.connectionDesc, this.providerId, connectionProfileProperties, "", false);
        }

        private String generateUniqueDriverDefinitionName(String driverDefinitionNameBase) {
            int index = 1;
            String testName = driverDefinitionNameBase;
            while (DriverManager.getInstance().getDriverInstanceByName(testName) != null) {
                testName = String.valueOf(driverDefinitionNameBase) + String.valueOf(++index);
            }
            return testName;
        }

        protected abstract String getDatabaseName(String var1);
    }

    private static class Msgs
    extends NLS {
        public static String addDBConnnection;
        public static String addProfileError;
        public static String noDatabasePropertyFile;
        public static String noDBConnectDriver;

        static {
            Msgs.initializeMessages((String)CreateDBConnectAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    private class MysqlLiferayDatabaseConnection
    extends LiferayDatabaseConnection {
        public MysqlLiferayDatabaseConnection(String driverClass, String providerId, String connectinDesc, String driverTemplate, String userName, String password, String connectionUrl) {
            super(driverClass, providerId, connectinDesc, driverTemplate, userName, password, connectionUrl);
        }

        @Override
        protected String getDatabaseName(String connectionUrl) {
            String databaseName;
            int databaseNameBegin;
            String databaseNameTmp;
            int databaseNameEnd;
            String retval = "lportal";
            if (!(CoreUtil.isNullOrEmpty((String)connectionUrl) || (databaseNameEnd = connectionUrl.indexOf("?")) <= 0 || CoreUtil.isNullOrEmpty((String)(databaseNameTmp = connectionUrl.substring(0, databaseNameEnd))) || (databaseNameBegin = databaseNameTmp.lastIndexOf("/")) <= 0 || CoreUtil.isNullOrEmpty((String)(databaseName = connectionUrl.substring(databaseNameBegin + 1, databaseNameEnd))))) {
                retval = databaseName;
            }
            return retval;
        }
    }

    private class PostgresqlLiferayDatabaseConnection
    extends LiferayDatabaseConnection {
        public PostgresqlLiferayDatabaseConnection(String driverClass, String providerId, String connectinDesc, String driverTemplate, String userName, String password, String connectionUrl) {
            super(driverClass, providerId, connectinDesc, driverTemplate, userName, password, connectionUrl);
        }

        @Override
        protected String getDatabaseName(String connectionUrl) {
            String databaseName;
            int databaseNameBegin;
            String retval = "lportal";
            if (!CoreUtil.isNullOrEmpty((String)connectionUrl) && (databaseNameBegin = connectionUrl.lastIndexOf("/")) > 0 && !CoreUtil.isNullOrEmpty((String)(databaseName = connectionUrl.substring(databaseNameBegin + 1)))) {
                retval = databaseName;
            }
            return retval;
        }
    }
}

