/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.handlers;

import com.liferay.ide.server.core.ILiferayServer;
import com.liferay.ide.server.ui.LiferayServerUI;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public abstract class OpenPortalURLHandler
extends AbstractHandler {
    protected IWorkbenchPart activePart;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object selected;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selected = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && selected instanceof IServer) {
            final ILiferayServer portalServer = this.getLiferayServer(selected);
            new Job(Msgs.openPortalUrl){

                protected IStatus run(IProgressMonitor monitor) {
                    OpenPortalURLHandler.this.openPortalURL(portalServer, selected);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        return null;
    }

    protected IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    protected Shell getActiveShell() {
        if (this.getActivePart() != null) {
            return this.getActivePart().getSite().getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected ILiferayServer getLiferayServer(Object selected) {
        IServer iServer = null;
        if (selected instanceof IServer) {
            iServer = (IServer)selected;
        }
        return (ILiferayServer)iServer.loadAdapter(ILiferayServer.class, null);
    }

    protected abstract URL getPortalURL(Object var1);

    protected abstract String getPortalURLTitle();

    protected int getRequiredServerState() {
        return 2;
    }

    protected void openBrowser(final URL url, final String browserTitle) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchBrowserSupport browserSupport = ServerUIPlugin.getInstance().getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, browserTitle, null);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    LiferayServerUI.logError(e);
                }
            }
        });
    }

    protected void openPortalURL(ILiferayServer portalServer, Object seleted) {
        URL portalUrl = this.getPortalURL(seleted);
        if (portalUrl == null) {
            MessageDialog.openError((Shell)this.getActiveShell(), (String)Msgs.openPortalURL, (String)Msgs.notDeterminePortalURL);
            return;
        }
        this.openBrowser(portalUrl, this.getPortalURLTitle());
    }

    private static class Msgs
    extends NLS {
        public static String notDeterminePortalURL;
        public static String openPortalUrl;
        public static String openPortalURL;

        static {
            Msgs.initializeMessages((String)OpenPortalURLHandler.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

