/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.wizard;

import com.liferay.ide.server.remote.IRemoteServerWorkingCopy;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.wizard.RemoteServerComposite;
import com.liferay.ide.ui.util.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class RemoteServerWizardFragment
extends WizardFragment {
    protected RemoteServerComposite composite;
    protected IStatus lastServerStatus = null;
    protected IWizardHandle wizard;

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.wizard = wizard;
        this.composite = new RemoteServerComposite(parent, this, wizard);
        wizard.setTitle(Msgs.remoteLiferayServer);
        wizard.setDescription(Msgs.configureRemoteLiferayServerInstance);
        wizard.setImageDescriptor(ImageDescriptor.createFromURL((URL)LiferayServerUI.getDefault().getBundle().getEntry("/icons/wizban/server_wiz.png")));
        return this.composite;
    }

    public void enter() {
        if (this.composite != null && !this.composite.isDisposed()) {
            IServerWorkingCopy serverWC = this.getServerWorkingCopy();
            this.composite.setServer(serverWC);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        return this.lastServerStatus != null && this.lastServerStatus.getSeverity() != 4;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        try {
            this.wizard.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (RemoteServerWizardFragment.this.lastServerStatus == null || !RemoteServerWizardFragment.this.lastServerStatus.isOK()) {
                        RemoteServerWizardFragment.this.lastServerStatus = RemoteServerWizardFragment.this.getRemoteServerWC().validate(monitor);
                        if (!RemoteServerWizardFragment.this.lastServerStatus.isOK()) {
                            throw new InterruptedException(RemoteServerWizardFragment.this.lastServerStatus.getMessage());
                        }
                    }
                }
            });
        }
        catch (Exception exception) {}
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)new IServerLifecycleListener(){
            String id;
            {
                this.id = RemoteServerWizardFragment.this.getServerWorkingCopy().getId();
            }

            public void serverAdded(final IServer server) {
                if (server.getId().equals(this.id)) {
                    UIUtil.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IViewPart serversView = UIUtil.showView((String)"org.eclipse.wst.server.ui.ServersView");
                            CommonViewer viewer = (CommonViewer)serversView.getAdapter(CommonViewer.class);
                            viewer.setSelection((ISelection)new StructuredSelection((Object)server));
                        }
                    });
                    ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this);
                    server.addServerListener(new IServerListener(){

                        public void serverChanged(ServerEvent event) {
                            if (event.getServer().getServerState() == 2) {
                                server.publish(1, null, null, null);
                                server.removeServerListener((IServerListener)this);
                            }
                        }
                    });
                }
            }

            public void serverChanged(IServer server) {
            }

            public void serverRemoved(IServer server) {
            }
        });
    }

    protected IServerWorkingCopy getServerWorkingCopy() {
        return (IServerWorkingCopy)this.getTaskModel().getObject("server");
    }

    IRemoteServerWorkingCopy getRemoteServerWC() {
        return (IRemoteServerWorkingCopy)this.getServerWorkingCopy().loadAdapter(IRemoteServerWorkingCopy.class, null);
    }

    private static class Msgs
    extends NLS {
        public static String configureRemoteLiferayServerInstance;
        public static String remoteLiferayServer;

        static {
            Msgs.initializeMessages((String)RemoteServerWizardFragment.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

