/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractDefaultHandler
extends DefaultHandler {
    protected boolean dtd = false;
    protected SAXParserFactory fFactory;
    protected int fLevel = -1;
    protected String fTopElementFound;
    protected String publicIdPrefix;
    protected String publicIdSuffix;
    protected String rootElement;
    protected String systemIdPrefix;
    protected String systemIdSuffix;
    protected boolean topLevelElement = false;

    public AbstractDefaultHandler(String publicIdPrefix, String publicIdSuffix, String systemIdPrefix, String systemIdSuffix, String rootElement) {
        this.publicIdPrefix = publicIdPrefix;
        this.publicIdSuffix = publicIdSuffix;
        this.systemIdPrefix = systemIdPrefix;
        this.systemIdSuffix = systemIdSuffix;
        this.rootElement = rootElement;
    }

    public boolean hasDTD() {
        return this.dtd;
    }

    public boolean hasTopLevelElement() {
        return this.topLevelElement;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (systemId != null && systemId.startsWith(this.systemIdPrefix) && systemId.endsWith(this.systemIdSuffix) && publicId != null && publicId.startsWith(this.publicIdPrefix) && publicId.endsWith(this.publicIdSuffix)) {
            this.dtd = true;
        }
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.fLevel;
        if (this.fTopElementFound == null) {
            this.fTopElementFound = localName;
            this.topLevelElement = this.hasRootProjectElement();
            throw new StopParsingException();
        }
    }

    protected final SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser parser = parserFactory.newSAXParser();
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SAXParserFactory getFactory() {
        AbstractDefaultHandler abstractDefaultHandler = this;
        synchronized (abstractDefaultHandler) {
            if (this.fFactory != null) {
                return this.fFactory;
            }
            this.fFactory = SAXParserFactory.newInstance();
            this.fFactory.setNamespaceAware(true);
        }
        return this.fFactory;
    }

    protected boolean hasRootProjectElement() {
        return this.rootElement != null && this.rootElement.equals(this.fTopElementFound);
    }

    protected boolean parseContents(InputSource contents) throws IOException, ParserConfigurationException, SAXException {
        block3: {
            try {
                this.fFactory = this.getFactory();
                if (this.fFactory != null) break block3;
                return false;
            }
            catch (StopParsingException stopParsingException) {}
        }
        SAXParser parser = this.createParser(this.fFactory);
        parser.parse(contents, (DefaultHandler)this);
        return true;
    }

    protected class StopParsingException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public StopParsingException() {
            super((String)null);
        }
    }
}

