/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ExtensionReader;
import com.liferay.ide.core.ILiferayProjectProvider;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;

public class LiferayProjectProviderReader
extends ExtensionReader<ILiferayProjectProvider> {
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_DISPLAYNAME = "displayName";
    private static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String ATTRIBUTE_SHORTNAME = "shortName";
    private static final String ATTRIBUTE_PROJECTTYPE = "projectType";
    private static final String EXTENSION = "liferayProjectProviders";
    private static final String PROVIDER_ELEMENT = "liferayProjectProvider";

    public LiferayProjectProviderReader() {
        super("com.liferay.ide.core", EXTENSION, PROVIDER_ELEMENT);
    }

    public ILiferayProjectProvider[] getProviders() {
        return this.getExtensions().toArray(new ILiferayProjectProvider[0]);
    }

    public ILiferayProjectProvider[] getProviders(Class<?> type) {
        ArrayList<ILiferayProjectProvider> providers = new ArrayList<ILiferayProjectProvider>();
        for (ILiferayProjectProvider provider : this.getExtensions()) {
            if (!provider.provides(type)) continue;
            providers.add(provider);
        }
        return providers.toArray(new ILiferayProjectProvider[0]);
    }

    @Override
    protected ILiferayProjectProvider initElement(IConfigurationElement configElement, ILiferayProjectProvider provider) {
        String shortName = configElement.getAttribute(ATTRIBUTE_SHORTNAME);
        String displayName = configElement.getAttribute(ATTRIBUTE_DISPLAYNAME);
        String priority = configElement.getAttribute(ATTRIBUTE_PRIORITY);
        String type = configElement.getAttribute(ATTRIBUTE_PROJECTTYPE);
        boolean isDefault = Boolean.parseBoolean(configElement.getAttribute(ATTRIBUTE_DEFAULT));
        AbstractLiferayProjectProvider projectProvider = (AbstractLiferayProjectProvider)provider;
        projectProvider.setShortName(shortName);
        projectProvider.setDisplayName(displayName);
        projectProvider.setProjectType(type);
        int priorityValue = 10;
        if ("lowest".equals(priority)) {
            priorityValue = 1;
        } else if ("low".equals(priority)) {
            priorityValue = 2;
        } else if ("normal".equals(priority)) {
            priorityValue = 3;
        } else if ("high".equals(priority)) {
            priorityValue = 4;
        } else if ("highest".equals(priority)) {
            priorityValue = 5;
        }
        projectProvider.setPriority(priorityValue);
        projectProvider.setDefault(isDefault);
        return provider;
    }

    public ILiferayProjectProvider[] getProviders(String projectType) {
        ILiferayProjectProvider[] providers;
        ArrayList<ILiferayProjectProvider> retval = new ArrayList<ILiferayProjectProvider>();
        ILiferayProjectProvider[] iLiferayProjectProviderArray = providers = this.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ILiferayProjectProvider provider = iLiferayProjectProviderArray[n2];
            if (provider.getProjectType().equals(projectType)) {
                retval.add(provider);
            }
            ++n2;
        }
        return retval.toArray(new ILiferayProjectProvider[0]);
    }
}

