/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.LiferayCore;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class RegistryReader {
    private static final String JEM_PLUGIN_ID = "org.eclipse.jem.util";
    String pluginId;
    String extensionPointId;
    private static Bundle systemBundle;

    public static String getPluginId(IConfigurationElement configurationElement) {
        IExtension extension;
        String pluginId = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            pluginId = extension.getContributor().getName();
        }
        return pluginId;
    }

    public RegistryReader(IPluginRegistry registry, String pluginID, String extensionPoint) {
        this(pluginID, extensionPoint);
    }

    public RegistryReader(String pluginID, String extensionPoint) {
        this.pluginId = pluginID;
        this.extensionPointId = extensionPoint;
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        LiferayCore.logError(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    public abstract boolean readElement(IConfigurationElement var1);

    public void readRegistry() {
        int i;
        IConfigurationElement[] elements;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.pluginId, this.extensionPointId);
        if (point != null) {
            elements = point.getConfigurationElements();
            i = 0;
            while (i < elements.length) {
                this.internalReadElement(elements[i]);
                ++i;
            }
        }
        if (!JEM_PLUGIN_ID.equals(this.pluginId) && (point = Platform.getExtensionRegistry().getExtensionPoint(JEM_PLUGIN_ID, this.extensionPointId)) != null) {
            elements = point.getConfigurationElements();
            i = 0;
            while (i < elements.length) {
                this.internalReadElement(elements[i]);
                ++i;
            }
        }
    }

    public static boolean canCreateExecutableExtension(IConfigurationElement element) {
        return Platform.isRunning() && RegistryReader.getSystemBundle().getState() != 16;
    }

    protected static Bundle getSystemBundle() {
        if (systemBundle == null) {
            systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
        }
        return systemBundle;
    }
}

