/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchQuery;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.participant.IMatchPresentation;

public class XMLSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    protected static final Match[] NO_MATCHES = new Match[0];
    private XMLSearchQuery fQuery;
    private final Map<Object, IMatchPresentation> fElementsToParticipants;

    public XMLSearchResult(XMLSearchQuery query) {
        this.fQuery = query;
        this.fElementsToParticipants = new HashMap<Object, IMatchPresentation>();
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches((IAdaptable)editor.getEditorInput());
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches((IAdaptable)file);
    }

    private Match[] computeContainedMatches(IAdaptable adaptable) {
        return NO_MATCHES;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            IStructuredModel editorModel = (IStructuredModel)editor.getAdapter(IStructuredModel.class);
            if (editorModel != null) {
                return editorModel.equals(node.getModel());
            }
        }
        return false;
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            return DOMUtils.getFile((IDOMNode)node);
        }
        return null;
    }

    public synchronized IMatchPresentation getSearchParticpant(Object element) {
        return this.fElementsToParticipants.get(element);
    }

    boolean addMatch(Match match, IMatchPresentation participant) {
        Object element = match.getElement();
        if (this.fElementsToParticipants.get(element) != null) {
            XMLSearchUIPlugin.log((IStatus)new Status(2, "org.eclipse.wst.xml.search.ui", 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(element, participant);
        this.addMatch(match);
        return true;
    }
}

