/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.gradle.core.LiferayGradleProject;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOpMethods;
import com.liferay.ide.project.core.modules.PropertyKey;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.workspace.SynchronizeGradleProjectsJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.gradle.jarjar.org.apache.commons.lang.WordUtils;

public class GradleProjectProvider
extends AbstractLiferayProjectProvider
implements NewLiferayProjectProvider<NewLiferayModuleProjectOp> {
    public GradleProjectProvider() {
        super(new Class[]{IProject.class});
    }

    public synchronized ILiferayProject provide(Object adaptable) {
        ILiferayProject retval = null;
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            try {
                if (LiferayNature.hasNature((IProject)project) && GradleProjectNature.INSTANCE.isPresentOn(project)) {
                    return new LiferayGradleProject(project);
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public IStatus createNewProject(NewLiferayModuleProjectOp op, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        String projectName = (String)op.getProjectName().content();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        String className = (String)op.getComponentName().content();
        String serviceName = (String)op.getServiceName().content();
        String packageName = (String)op.getPackageName().content();
        ElementList propertyKeys = op.getPropertyKeys();
        ArrayList<String> properties = new ArrayList<String>();
        for (PropertyKey propertyKey : propertyKeys) {
            properties.add(String.valueOf((String)propertyKey.getName().content(true)) + "=" + (String)propertyKey.getValue().content(true));
        }
        String projectTemplateName = (String)op.getProjectTemplateName().content();
        StringBuilder sb = new StringBuilder();
        sb.append("create ");
        sb.append("-d \"" + location.toFile().getAbsolutePath() + "\" ");
        sb.append("-t " + projectTemplateName + " ");
        if (className != null) {
            sb.append("-c " + className + " ");
        }
        if (serviceName != null) {
            sb.append("-s " + serviceName + " ");
        }
        if (packageName != null) {
            sb.append("-p " + packageName + " ");
        }
        sb.append("\"" + projectName + "\" ");
        try {
            IPath modulesPath;
            String liferayWorkspaceProjectModulesDir;
            IPath workspaceLocation;
            IPath finalClassPath;
            File finalClassFile;
            String[] ret = BladeCLI.execute((String)sb.toString());
            String errors = BladeCLI.checkForErrors((String[])ret);
            if (errors.length() > 0) {
                retval = GradleCore.createErrorStatus("Project create error: " + errors);
                return retval;
            }
            ElementList projectNames = op.getProjectNames();
            ((ProjectName)projectNames.insert()).setName(projectName);
            IPath projecLocation = location;
            String lastSegment = location.lastSegment();
            if (location != null && location.segmentCount() > 0 && !lastSegment.equals(projectName)) {
                projecLocation = location.append(projectName);
            }
            if ((finalClassFile = (finalClassPath = this.getClassFilePath(projectName, className, packageName, projectTemplateName, projecLocation)).toFile()).exists()) {
                NewLiferayModuleProjectOpMethods.addProperties((File)finalClassFile, properties);
            }
            boolean hasLiferayWorkspace = LiferayWorkspaceUtil.hasLiferayWorkspace();
            boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
            boolean inWorkspacePath = false;
            IProject liferayWorkspaceProject = LiferayWorkspaceUtil.getLiferayWorkspaceProject();
            if (liferayWorkspaceProject != null && !useDefaultLocation && (workspaceLocation = liferayWorkspaceProject.getLocation()) != null && (liferayWorkspaceProjectModulesDir = LiferayWorkspaceUtil.getLiferayWorkspaceProjectModulesDir((IProject)liferayWorkspaceProject)) != null && (modulesPath = workspaceLocation.append(liferayWorkspaceProjectModulesDir)).isPrefixOf(projecLocation)) {
                inWorkspacePath = true;
            }
            if (hasLiferayWorkspace && useDefaultLocation || inWorkspacePath) {
                IProject[] projects = new IProject[]{liferayWorkspaceProject};
                SynchronizeGradleProjectsJob synchronizeJob = new SynchronizeGradleProjectsJob(Arrays.asList(projects));
                synchronizeJob.schedule();
            } else {
                GradleUtil.importGradleProject(projecLocation.toFile(), monitor);
            }
        }
        catch (Exception e) {
            retval = GradleCore.createErrorStatus("can't create module project.", e);
        }
        return retval;
    }

    private IPath getClassFilePath(String projectName, String className, String packageName, String projectTemplateName, IPath projecLocation) {
        if (CoreUtil.isNullOrEmpty((String)className)) {
            className = WordUtils.capitalize((String)projectName);
        }
        if ((projectTemplateName.equals("servicebuilder") || projectTemplateName.equals("portlet") || projectTemplateName.equals("mvcportlet")) && !className.contains("Portlet")) {
            className = String.valueOf(className) + "Portlet";
        }
        String finalClassName = String.valueOf(className) + ".java";
        String[] finalPakcage = packageName.split("\\.");
        IPath packageNamePath = projecLocation.append("src").append("main").append("java");
        String[] stringArray = finalPakcage;
        int n = finalPakcage.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            packageNamePath = packageNamePath.append(pack);
            ++n2;
        }
        IPath finalClassPath = packageNamePath.append(finalClassName);
        return finalClassPath;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        File projectFodler;
        IStatus retval = Status.OK_STATUS;
        if (path != null && LiferayWorkspaceUtil.isValidWorkspaceLocation((String)path.toOSString())) {
            retval = GradleCore.createErrorStatus(" Can't set WorkspaceProject root folder as project directory. ");
        }
        if ((projectFodler = path.append(projectName).toFile()).exists()) {
            retval = GradleCore.createErrorStatus(" Project folder is not empty. ");
        }
        return retval;
    }
}

