/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.gradle.core.modules.NewJSPHookModuleOp;
import com.liferay.ide.gradle.core.modules.OSGiCustomJSP;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.modules.BladeCLI;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class JSPHookProjectProvider
extends AbstractLiferayProjectProvider
implements NewLiferayProjectProvider<NewJSPHookModuleOp> {
    public JSPHookProjectProvider() {
        super(null);
    }

    public synchronized ILiferayProject provide(Object adaptable) {
        return null;
    }

    public IStatus createNewProject(NewJSPHookModuleOp op, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        String projectName = (String)op.getProjectName().content();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        String hostBundle = (String)op.getCustomOSGiBundle().content();
        IPath temp = GradleCore.getDefault().getStateLocation().append(hostBundle);
        try {
            ZipUtil.unzip((File)new File((String)op.getRealOSGiBundleFile().content()), (File)temp.toFile());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String bundleSymbolicName = "";
        String version = "";
        if (temp.toFile().exists()) {
            String[] contents;
            File file = temp.append("META-INF").append("MANIFEST.MF").toFile();
            String[] stringArray = contents = FileUtil.readLinesFromFile((File)file);
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String content = stringArray[n2];
                if (content.contains("Bundle-SymbolicName:")) {
                    bundleSymbolicName = content.substring(content.indexOf("Bundle-SymbolicName:") + "Bundle-SymbolicName:".length());
                }
                if (content.contains("Bundle-Version:")) {
                    version = content.substring(content.indexOf("Bundle-Version:") + "Bundle-Version:".length());
                }
                ++n2;
            }
        }
        ElementList<OSGiCustomJSP> jsps = op.getCustomJSPs();
        StringBuilder sb = new StringBuilder();
        sb.append("create ");
        sb.append("-d \"" + location.toFile().getAbsolutePath() + "\" ");
        sb.append("-t jsphook ");
        if (!bundleSymbolicName.equals("")) {
            sb.append("-h " + bundleSymbolicName + " ");
        }
        if (!version.equals("")) {
            sb.append("-H " + version + " ");
        }
        sb.append("\"" + projectName + "\" ");
        try {
            String[] ret = BladeCLI.execute((String)sb.toString());
            String errors = BladeCLI.checkForErrors((String[])ret);
            if (errors.length() > 0) {
                retval = GradleCore.createErrorStatus("Project create error: " + errors);
                return retval;
            }
            IPath projecLocation = location;
            String lastSegment = location.lastSegment();
            if (location != null && location.segmentCount() > 0 && !lastSegment.equals(projectName)) {
                projecLocation = location.append(projectName);
            }
            for (OSGiCustomJSP jsp : jsps) {
                File jspFile = temp.append((String)jsp.getValue().content()).toFile();
                if (!jspFile.exists()) continue;
                String parent = jspFile.getParentFile().getPath();
                parent = parent.replaceAll("\\\\", "/");
                String metaInfResources = "META-INF/resources";
                parent = parent.substring(parent.indexOf(metaInfResources) + metaInfResources.length());
                IPath resources = location.append(projectName).append("src").append("main").append("resources").append("META-INF").append("resources");
                File folder = resources.toFile();
                if (!parent.equals("resources") && !parent.equals("")) {
                    folder = resources.append(parent).toFile();
                    folder.mkdirs();
                }
                FileUtil.copyFileToDir((File)jspFile, (File)folder);
            }
            GradleUtil.importGradleProject(projecLocation.toFile(), monitor);
        }
        catch (Exception e) {
            retval = GradleCore.createErrorStatus("can't create module project.", e);
        }
        return retval;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval = Status.OK_STATUS;
        File projectFodler = path.append(projectName).toFile();
        if (projectFodler.exists()) {
            retval = GradleCore.createErrorStatus(" Project folder is not empty. ");
        }
        return retval;
    }
}

