/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.gradle.core.LiferayWorkspaceProject;
import com.liferay.ide.gradle.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.BladeCLIException;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.platform.PathBridge;

public class LiferayWorkspaceProjectProvider
extends AbstractLiferayProjectProvider
implements NewLiferayProjectProvider<NewLiferayWorkspaceOp> {
    public LiferayWorkspaceProjectProvider() {
        super(new Class[]{IProject.class});
    }

    public IStatus createNewProject(NewLiferayWorkspaceOp op, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        IPath location = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)op.getLocation().content()));
        StringBuilder sb = new StringBuilder();
        sb.append("-b ");
        sb.append("\"" + location.toFile().getAbsolutePath() + "\" ");
        sb.append("init");
        try {
            BladeCLI.execute((String)sb.toString());
        }
        catch (BladeCLIException e) {
            retval = ProjectCore.createErrorStatus((Exception)((Object)e));
        }
        return retval;
    }

    public IStatus importProject(String location, IProgressMonitor monitor, String extraOperation) {
        try {
            IStatus importJob = GradleUtil.importGradleProject(new File(location), monitor);
            if (!importJob.isOK()) {
                return importJob;
            }
            if (!CoreUtil.empty((String)extraOperation)) {
                Path path = new Path(location);
                path.lastSegment();
                IProject project = CoreUtil.getProject((String)path.lastSegment());
                GradleUtil.runGradleTask(project, extraOperation, monitor);
                project.refreshLocal(2, monitor);
            }
        }
        catch (CoreException e) {
            return GradleCore.createErrorStatus("import Liferay workspace project error", (Exception)((Object)e));
        }
        return Status.OK_STATUS;
    }

    public synchronized ILiferayProject provide(Object adaptable) {
        IProject project;
        ILiferayProject retval = null;
        if (adaptable instanceof IProject && LiferayWorkspaceUtil.isValidWorkspace((IProject)(project = (IProject)adaptable))) {
            return new LiferayWorkspaceProject(project);
        }
        return retval;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval = Status.OK_STATUS;
        return retval;
    }
}

