/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.ivysettings;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.util.StringUtils;
import org.apache.ivyde.common.ivysettings.IvySettingsFile;
import org.apache.ivyde.common.model.IvyBooleanTagAttribute;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModel;
import org.apache.ivyde.common.model.IvyModelSettings;
import org.apache.ivyde.common.model.IvyReferenceTag;
import org.apache.ivyde.common.model.IvyTag;
import org.apache.ivyde.common.model.IvyTagAttribute;

public class IvySettingsModel
extends IvyModel {
    private String loaded = null;
    private File file;
    private ClassLoader cl;
    private Map typedefClasses;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;

    public IvySettingsModel(IvyModelSettings settings, File file) {
        super(settings);
        this.file = file;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ivy.Ivy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cl = clazz.getClassLoader();
        this.typedefClasses = this.getTypedefClasses(this.cl, IvySettingsFile.getDefaultTypedefs());
        this.doLoadModel();
    }

    public void refreshIfNeeded(IvyFile file) {
        String toLoad = this.getLoad(file);
        if (!toLoad.equals(this.loaded)) {
            this.doRefresh(file, toLoad);
        }
    }

    private String getLoad(IvyFile file) {
        IvySettingsFile sfile = (IvySettingsFile)file;
        return Arrays.asList(sfile.getClasspathUrls()) + "|" + sfile.getTypedefs();
    }

    private void doRefresh(IvyFile file, String toLoad) {
        IvySettingsFile sfile = (IvySettingsFile)file;
        this.clearModel();
        this.cl = this.getClassLoader(sfile);
        this.typedefClasses = this.getTypedefClasses(sfile, this.cl);
        this.doLoadModel();
        this.loaded = toLoad;
    }

    private void doLoadModel() {
        IvyTag ivyTag = new IvyTag("ivysettings", "Root tag of Ivy settings file");
        ivyTag.addChildIvyTag(new IvyTag("property", new IvyTagAttribute[]{new IvyTagAttribute("name", true), new IvyTagAttribute("value", true), new IvyBooleanTagAttribute("override")}));
        ivyTag.addChildIvyTag(new IvyTag("properties", new IvyTagAttribute[]{new IvyTagAttribute("file", true), new IvyTagAttribute("environment"), new IvyBooleanTagAttribute("override")}));
        ivyTag.addChildIvyTag(new IvyTag("settings", new IvyTagAttribute[]{new IvyTagAttribute("defaultResolver"), new IvyTagAttribute("defaultLatestStrategy"), new IvyTagAttribute("defaultConflictManager"), new IvyTagAttribute("defaultBranch"), new IvyTagAttribute("defaultResolveMode"), new IvyTagAttribute("circularDependencyStrategy"), new IvyBooleanTagAttribute("validate"), new IvyBooleanTagAttribute("useRemoteConfig")}));
        ivyTag.addChildIvyTag(new IvyTag("include", new IvyTagAttribute[]{new IvyTagAttribute("url"), new IvyTagAttribute("file")}));
        ivyTag.addChildIvyTag(new IvyTag("classpath", new IvyTagAttribute[]{new IvyTagAttribute("url"), new IvyTagAttribute("file")}));
        ivyTag.addChildIvyTag(new IvyTag("typedef", new IvyTagAttribute[]{new IvyTagAttribute("name"), new IvyTagAttribute("classname")}));
        IvyTag tag = new IvyTag("locking-strategies");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.ivy.plugins.lock.LockStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz));
        ivyTag.addChildIvyTag(tag);
        ivyTag.addChildIvyTag(new IvyTag("caches", new IvyTagAttribute[]{new IvyTagAttribute("default"), new IvyTagAttribute("defaultCacheDir"), new IvyTagAttribute("resolutionCacheDir"), new IvyTagAttribute("repositoryCacheDir"), new IvyTagAttribute("ivyPattern"), new IvyTagAttribute("artifactPattern"), new IvyBooleanTagAttribute("checkUpToDate"), new IvyBooleanTagAttribute("useOrigin"), new IvyTagAttribute("lockStrategy")}).addChildIvyTag(new IvyTag("cache", new IvyTagAttribute[]{new IvyTagAttribute("name"), new IvyTagAttribute("basedir"), new IvyTagAttribute("ivyPattern"), new IvyTagAttribute("artifactPattern"), new IvyBooleanTagAttribute("useOrigin"), new IvyTagAttribute("lockStrategy"), new IvyTagAttribute("defaultTTL")}).addChildIvyTag(new IvyTag("ttl", new IvyTagAttribute[]{new IvyTagAttribute("organisation"), new IvyTagAttribute("module"), new IvyTagAttribute("revision"), new IvyTagAttribute("matcher"), new IvyTagAttribute("duration", true)}))));
        tag = new IvyTag("latest-strategies");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.apache.ivy.plugins.latest.LatestStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz2));
        ivyTag.addChildIvyTag(tag);
        tag = new IvyTag("parsers");
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.apache.ivy.plugins.parser.ModuleDescriptorParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz3));
        ivyTag.addChildIvyTag(tag);
        tag = new IvyTag("namespaces");
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.apache.ivy.plugins.namespace.Namespace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz4));
        ivyTag.addChildIvyTag(tag);
        tag = new IvyTag("macrodef", new IvyTagAttribute[]{new IvyTagAttribute("name")}).addChildIvyTag(new IvyTag("attribute", new IvyTagAttribute[]{new IvyTagAttribute("name"), new IvyTagAttribute("default")}));
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.apache.ivy.plugins.resolver.DependencyResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz5));
        ivyTag.addChildIvyTag(tag);
        tag = new IvyTag("resolvers");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.apache.ivy.plugins.resolver.DependencyResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz6));
        tag.addChildIvyTag(new IvyReferenceTag("resolver"));
        ivyTag.addChildIvyTag(tag);
        tag = new IvyTag("conflict-managers");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.apache.ivy.plugins.conflict.ConflictManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz7));
        ivyTag.addChildIvyTag(tag);
        ivyTag.addChildIvyTag(new IvyTag("modules").addChildIvyTag(new IvyTag("module", new IvyTagAttribute[]{new IvyTagAttribute("organisation"), new IvyTagAttribute("name"), new IvyTagAttribute("revision"), new IvyTagAttribute("matcher"), new IvyTagAttribute("resolver"), new IvyTagAttribute("conflict-manager"), new IvyTagAttribute("branch"), new IvyTagAttribute("resolveMode")})));
        tag = new IvyTag("outputters");
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.apache.ivy.plugins.report.ReportOutputter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz8));
        ivyTag.addChildIvyTag(tag);
        ivyTag.addChildIvyTag(new IvyTag("statuses", new IvyTagAttribute[]{new IvyTagAttribute("default")}).addChildIvyTag(new IvyTag("status", new IvyTagAttribute[]{new IvyTagAttribute("name"), new IvyTagAttribute("integration")})));
        tag = new IvyTag("triggers");
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.apache.ivy.plugins.trigger.Trigger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz9));
        ivyTag.addChildIvyTag(tag);
        tag = new IvyTag("version-matchers");
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.apache.ivy.plugins.version.VersionMatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTypedefChildren(tag, this.getChildClasses(this.typedefClasses, clazz10));
        ivyTag.addChildIvyTag(tag);
        this.addTag(ivyTag);
    }

    private void addTypedefChildren(IvyTag tag, Map children) {
        Iterator it = children.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class clazz = (Class)entry.getValue();
            String childName = (String)entry.getKey();
            tag.addChildIvyTag(this.typedefedTag(childName, clazz));
        }
    }

    private IvyTag typedefedTag(String tagName, final Class clazz) {
        IvyTag child = new IvyTag(tagName){
            private boolean init;
            {
                super($anonymous0);
                this.init = false;
            }

            public List getAttributes() {
                this.init();
                return super.getAttributes();
            }

            public List getChilds() {
                this.init();
                return super.getChilds();
            }

            public boolean hasChild() {
                this.init();
                return super.hasChild();
            }

            private void init() {
                if (!this.init) {
                    try {
                        Method[] methods = clazz.getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            String name;
                            Method m = methods[i];
                            if (m.getName().startsWith("create") && m.getParameterTypes().length == 0 && IvySettingsModel.this.isSupportedChildType(m.getReturnType())) {
                                name = StringUtils.uncapitalize((String)m.getName().substring("create".length()));
                                if (name.length() != 0) {
                                    this.addChildIvyTag(IvySettingsModel.this.typedefedTag(name, m.getReturnType()));
                                }
                            } else if (m.getName().startsWith("add") && m.getParameterTypes().length == 1 && IvySettingsModel.this.isSupportedChildType(m.getParameterTypes()[0]) && Void.TYPE.equals(m.getReturnType())) {
                                name = StringUtils.uncapitalize((String)m.getName().substring(m.getName().startsWith("addConfigured") ? "addConfigured".length() : "add".length()));
                                if (name.length() == 0) {
                                    IvySettingsModel.this.addTypedefChildren(this, IvySettingsModel.this.getChildClasses(IvySettingsModel.this.typedefClasses, m.getParameterTypes()[0]));
                                } else {
                                    this.addChildIvyTag(IvySettingsModel.this.typedefedTag(name, m.getParameterTypes()[0]));
                                }
                            } else if (m.getName().startsWith("set") && Void.TYPE.equals(m.getReturnType()) && m.getParameterTypes().length == 1 && IvySettingsModel.this.isSupportedAttributeType(m.getParameterTypes()[0])) {
                                IvyTagAttribute att = new IvyTagAttribute(StringUtils.uncapitalize((String)m.getName().substring("set".length())));
                                if (m.getParameterTypes()[0] == Boolean.TYPE) {
                                    att.setValueProvider(IvyBooleanTagAttribute.VALUE_PROVIDER);
                                }
                                this.addAttribute(att);
                            }
                            ++i;
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        IvySettingsModel.this.getSettings().logError("impossible to init tag for " + clazz + ": " + e, null);
                    }
                    catch (Exception e) {
                        IvySettingsModel.this.getSettings().logError("error occured while initializing tag for " + clazz + ": " + e, e);
                    }
                    this.init = true;
                }
            }
        };
        return child;
    }

    protected boolean isSupportedChildType(Class type) {
        if (!Void.TYPE.equals(type)) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.equals(type)) {
                Class<?> clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.equals(type) && !Character.TYPE.equals(type)) {
                    Class<?> clazz3 = class$12;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$12 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz3.equals(type) && !Boolean.TYPE.equals(type)) {
                        Class<?> clazz4 = class$13;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$13 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz4.equals(type) && !Integer.TYPE.equals(type)) {
                            Class<?> clazz5 = class$14;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$14 = Class.forName("java.lang.Short");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!clazz5.equals(type) && !Short.TYPE.equals(type)) {
                                Class<?> clazz6 = class$15;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = class$15 = Class.forName("java.lang.Long");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (!clazz6.equals(type) && !Long.TYPE.equals(type)) {
                                    Class<?> clazz7 = class$16;
                                    if (clazz7 == null) {
                                        try {
                                            clazz7 = class$16 = Class.forName("java.lang.Class");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (!clazz7.equals(type)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean isSupportedAttributeType(Class type) {
        block38: {
            block37: {
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = class$10 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(type)) break block37;
                Class<?> clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.equals(type) || Character.TYPE.equals(type)) break block37;
                Class<?> clazz3 = class$12;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$12 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.equals(type) || Boolean.TYPE.equals(type)) break block37;
                Class<?> clazz4 = class$14;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$14 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz4.equals(type) || Short.TYPE.equals(type)) break block37;
                Class<?> clazz5 = class$13;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$13 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz5.equals(type) || Integer.TYPE.equals(type)) break block37;
                Class<?> clazz6 = class$15;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$15 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz6.equals(type) || Long.TYPE.equals(type)) break block37;
                Class<?> clazz7 = class$16;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$16 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz7.equals(type)) break block38;
            }
            return true;
        }
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            type.getConstructor(classArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ClassLoader getClassLoader(IvySettingsFile sfile) {
        if (sfile.getClasspathUrls().length > 0) {
            URL[] uRLArray = sfile.getClasspathUrls();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.ivy.Ivy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new URLClassLoader(uRLArray, clazz.getClassLoader());
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ivy.Ivy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getClassLoader();
    }

    private Map getTypedefClasses(IvySettingsFile file, ClassLoader cl) {
        Map typedefs = file.getTypedefs();
        return this.getTypedefClasses(cl, typedefs);
    }

    private Map getTypedefClasses(ClassLoader cl, Map typedefs) {
        LinkedHashMap classes = new LinkedHashMap();
        Iterator it = typedefs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            try {
                classes.put(entry.getKey(), cl.loadClass((String)entry.getValue()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return classes;
    }

    private Map getChildClasses(Map classes, Class type) {
        LinkedHashMap childClasses = new LinkedHashMap();
        Iterator it = classes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!type.isAssignableFrom((Class)entry.getValue())) continue;
            childClasses.put(entry.getKey(), entry.getValue());
        }
        return childClasses;
    }

    protected String getRootIvyTagName() {
        return "ivysettings";
    }

    public IvyFile newIvyFile(String name, String content, int documentOffset) {
        return new IvySettingsFile(this.getSettings(), this.file, name, content, documentOffset);
    }
}

