/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse;

import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class IvyMarkerManager {
    private IResource findResource(IProject project, String ivyXmlFile) {
        if (project == null) {
            return null;
        }
        IFile r = project.getFile(ivyXmlFile);
        if (!r.exists()) {
            r = project;
        }
        return r;
    }

    public void removeMarkers(IProject project, String ivyXmlFile) {
        IResource r = this.findResource(project, ivyXmlFile);
        if (r == null) {
            return;
        }
        this.removeMarkers(r);
    }

    public void removeMarkers(IResource r) {
        try {
            r.deleteMarkers("org.apache.ivyde.eclipse.marker", true, 2);
        }
        catch (CoreException e) {
            IvyPlugin.log(e);
        }
    }

    public void setResolveStatus(IStatus status, IProject project, String ivyXmlFile) {
        try {
            IResource r = this.findResource(project, ivyXmlFile);
            if (r == null) {
                return;
            }
            this.removeMarkers(r);
            if (status == Status.OK_STATUS) {
                return;
            }
            if (status.isMultiStatus()) {
                IStatus[] allStatus = ((MultiStatus)status).getChildren();
                int i = 0;
                while (i < allStatus.length) {
                    this.addMarker(r, allStatus[i]);
                    ++i;
                }
            } else {
                this.addMarker(r, status);
            }
        }
        catch (CoreException e) {
            IvyPlugin.log(e);
        }
    }

    private void addMarker(IResource r, IStatus status) throws CoreException {
        IMarker marker = r.createMarker("org.apache.ivyde.eclipse.marker");
        marker.setAttribute("message", (Object)status.getMessage());
        switch (status.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                IvyPlugin.logWarn("Unsupported resolve status: " + status.getSeverity());
            }
        }
    }
}

