/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.PathEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class IvyFilePathText
extends PathEditor {
    private Text ivyFilePathText;
    private DecoratedField ivyFilePathTextDeco;
    private IvyDEException ivyXmlError;
    private final List listeners = new ArrayList();
    private FieldDecoration errorDecoration;
    private Button defaultButton;

    public IvyFilePathText(Composite parent, int style, IProject project) {
        super(parent, 0, "Ivy File:", project, "*.xml");
    }

    protected Text createText(Composite parent) {
        this.errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.ivyFilePathTextDeco = new DecoratedField((Composite)this, 16512, new IControlCreator(){

            public Control createControl(Composite parent, int style) {
                return new Text(parent, 2052);
            }
        });
        this.ivyFilePathTextDeco.addFieldDecoration(this.errorDecoration, 16512, false);
        this.ivyFilePathTextDeco.hideDecoration(this.errorDecoration);
        this.ivyFilePathText = (Text)this.ivyFilePathTextDeco.getControl();
        this.ivyFilePathTextDeco.getLayoutControl().setLayoutData((Object)new GridData(4, 2, true, false));
        return this.ivyFilePathText;
    }

    protected boolean addButtons(Composite buttons) {
        this.defaultButton = new Button(buttons, 0);
        this.defaultButton.setLayoutData((Object)new GridData(3, 2, true, false));
        this.defaultButton.setText("Default");
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvyFilePathText.this.getText().setText("ivy.xml");
            }
        });
        return true;
    }

    protected void setFile(String f) {
        try {
            this.getText().setText(new File(f).toURI().toURL().toExternalForm());
            this.textUpdated();
        }
        catch (MalformedURLException ex) {
            IvyPlugin.logError("The file got from the file browser has not a valid URL", ex);
        }
    }

    protected void textUpdated() {
        this.ivyXmlPathUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IvyXmlPathListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remodeListener(IvyXmlPathListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public String getIvyFilePath() {
        return this.ivyFilePathText.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ivyXmlPathUpdated() {
        List list = this.listeners;
        synchronized (list) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((IvyXmlPathListener)it.next()).ivyXmlPathUpdated(this.ivyFilePathText.getText());
            }
        }
    }

    public void setIvyXmlError(IvyDEException error) {
        if (error == null) {
            this.ivyXmlError = null;
            this.ivyFilePathTextDeco.hideDecoration(this.errorDecoration);
            this.ivyFilePathTextDeco.hideHover();
        } else if (!error.equals(this.ivyXmlError)) {
            this.ivyXmlError = error;
            this.ivyFilePathTextDeco.showDecoration(this.errorDecoration);
            if (this.ivyFilePathText.isVisible()) {
                this.errorDecoration.setDescription(error.getShortMsg());
                this.ivyFilePathTextDeco.showHoverText(error.getShortMsg());
            }
        }
    }

    public void updateErrorMarker() {
        if (this.isVisible() && this.ivyXmlError != null) {
            this.errorDecoration.setDescription(this.ivyXmlError.getShortMsg());
            this.ivyFilePathTextDeco.showHoverText(this.ivyXmlError.getShortMsg());
        } else {
            this.ivyFilePathTextDeco.hideHover();
        }
    }

    public void init(String ivyXmlPath) {
        this.ivyFilePathText.setText(ivyXmlPath);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.ivyFilePathText.setEnabled(enabled);
    }

    public static interface IvyXmlPathListener {
        public void ivyXmlPathUpdated(String var1);
    }
}

