/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core;

import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.LiferayServerCore;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class LiferayRuntimeStubDelegate
extends RuntimeDelegate
implements ILiferayRuntime {
    protected static final String PROP_STUB_TYPE_ID = "stub-type-id";
    protected IRuntimeWorkingCopy tempRuntime = null;

    @Override
    public IPath getAppServerDeployDir() {
        return this.getLiferayRuntime().getAppServerDeployDir();
    }

    @Override
    public IPath getAppServerDir() {
        return this.getLiferayRuntime().getAppServerDir();
    }

    @Override
    public IPath getAppServerLibGlobalDir() {
        return this.getLiferayRuntime().getAppServerLibGlobalDir();
    }

    @Override
    public IPath getAppServerPortalDir() {
        return this.getLiferayRuntime().getAppServerPortalDir();
    }

    @Override
    public String getAppServerType() {
        return this.getLiferayRuntime().getAppServerType();
    }

    @Override
    public String[] getHookSupportedProperties() {
        return this.getLiferayRuntime().getHookSupportedProperties();
    }

    @Override
    public String getJavadocURL() {
        return this.getLiferayRuntime().getJavadocURL();
    }

    @Override
    public IPath getLiferayHome() {
        return this.getLiferayRuntime().getLiferayHome();
    }

    public ILiferayRuntime getLiferayRuntime() {
        return (ILiferayRuntime)this.getTempRuntime().loadAdapter(ILiferayRuntime.class, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getName() {
        return this.getRuntime().getName();
    }

    @Override
    public String getPortalVersion() {
        return this.getLiferayRuntime().getPortalVersion();
    }

    @Override
    public Properties getPortletCategories() {
        return this.getLiferayRuntime().getPortletCategories();
    }

    @Override
    public Properties getPortletEntryCategories() {
        return this.getLiferayRuntime().getPortletEntryCategories();
    }

    @Override
    public IPath getRuntimeLocation() {
        return this.getRuntime().getLocation();
    }

    public String getRuntimeStubTypeId() {
        return this.getAttribute(PROP_STUB_TYPE_ID, "");
    }

    @Override
    public IPath getSourceLocation() {
        return this.getLiferayRuntime().getSourceLocation();
    }

    protected IRuntimeWorkingCopy getTempRuntime() {
        if (this.tempRuntime == null && this.getRuntime().getLocation() != null) {
            IRuntimeType runtimeType = ServerCore.findRuntimeType((String)this.getRuntimeStubTypeId());
            try {
                this.tempRuntime = runtimeType.createRuntime(String.valueOf(this.getRuntimeStubTypeId()) + "-stub", (IProgressMonitor)new NullProgressMonitor());
                this.tempRuntime.setLocation(this.getRuntime().getLocation());
            }
            catch (CoreException e) {
                LiferayServerCore.logError("Error creating runtime", e);
            }
        }
        if (this.tempRuntime.getLocation() == null || !this.tempRuntime.getLocation().equals((Object)this.getRuntime().getLocation())) {
            this.tempRuntime.setLocation(this.getRuntime().getLocation());
        }
        return this.tempRuntime;
    }

    @Override
    public IPath[] getUserLibs() {
        return this.getLiferayRuntime().getUserLibs();
    }

    public IVMInstall getVMInstall() {
        return JavaRuntime.getDefaultVMInstall();
    }

    public boolean isUsingDefaultJRE() {
        return true;
    }

    public void setRuntimeStubTypeId(String typeId) {
        this.setAttribute(PROP_STUB_TYPE_ID, typeId);
        this.tempRuntime = null;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        return ((RuntimeDelegate)this.getTempRuntime().loadAdapter(RuntimeDelegate.class, (IProgressMonitor)new NullProgressMonitor())).validate();
    }
}

