/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.server.core.portal.AbstractPortalBundle;
import com.liferay.ide.server.core.portal.PortalBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PortalJBossBundle
extends AbstractPortalBundle
implements PortalBundle {
    public static final int DEFAULT_JMX_PORT = 2099;

    public PortalJBossBundle(IPath path) {
        super(path);
    }

    public PortalJBossBundle(Map<String, String> appServerProperties) {
        super(appServerProperties);
    }

    @Override
    public IPath getAppServerDeployDir() {
        return this.bundlePath.append("/standalone/deployments/");
    }

    @Override
    public IPath getAppServerLibGlobalDir() {
        return this.getAppServerDir().append("/modules/com/liferay/portal/main");
    }

    @Override
    protected IPath getAppServerLibDir() {
        return this.getAppServerDir().append("modules");
    }

    @Override
    protected int getDefaultJMXRemotePort() {
        return 2099;
    }

    @Override
    public String getMainClass() {
        return "org.jboss.modules.Main";
    }

    public IPath getAppServerPortalDir() {
        IPath retval = null;
        if (this.bundlePath != null) {
            retval = this.bundlePath.append("/standalone/deployments/ROOT.war");
        }
        return retval;
    }

    @Override
    public IPath getOSGiBundlesDir() {
        return null;
    }

    @Override
    public IPath[] getRuntimeClasspath() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        if (this.bundlePath.toFile().exists()) {
            paths.add(this.bundlePath.append("jboss-modules.jar"));
        }
        return paths.toArray(new IPath[0]);
    }

    @Override
    public String[] getRuntimeStartProgArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-mp");
        args.add("\"" + this.bundlePath.toPortableString() + "/modules" + "\"");
        args.add("-jaxpmodule");
        args.add("javax.xml.jaxp-provider");
        args.add("org.jboss.as.standalone");
        args.add("-b");
        args.add("localhost");
        args.add("--server-config=standalone.xml");
        args.add("-Djboss.server.base.dir=\"" + this.bundlePath.toPortableString() + "/standalone/" + "\"");
        return args.toArray(new String[0]);
    }

    @Override
    public String[] getRuntimeStopProgArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-mp");
        args.add("\"" + this.bundlePath.toPortableString() + "/modules" + "\"");
        args.add("org.jboss.as.cli");
        args.add("--controller=localhost:9999");
        args.add("--connect");
        args.add("--command=:shutdown");
        return args.toArray(new String[0]);
    }

    @Override
    public String[] getRuntimeStartVMArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Dcom.sun.management.jmxremote");
        args.add("-Dcom.sun.management.jmxremote.authenticate=false");
        args.add("-Dcom.sun.management.jmxremote.port=" + this.getJmxRemotePort());
        args.add("-Dcom.sun.management.jmxremote.ssl=false");
        args.add("-Dorg.jboss.resolver.warning=true");
        args.add("-Djava.net.preferIPv4Stack=true");
        args.add("-Dsun.rmi.dgc.client.gcInterval=3600000");
        args.add("-Dsun.rmi.dgc.server.gcInterval=3600000");
        args.add("-Djboss.modules.system.pkgs=org.jboss.byteman");
        args.add("-Djava.awt.headless=true");
        args.add("-Dfile.encoding=UTF8");
        args.add("-server");
        args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
        args.add("-Xbootclasspath/p:\"" + this.bundlePath + "/modules/org/jboss/logmanager/main/jboss-logmanager-1.2.2.GA.jar" + "\"");
        args.add("-Xbootclasspath/p:\"" + this.bundlePath + "/modules/org/jboss/logmanager/log4j/main/jboss-logmanager-log4j-1.0.0.GA.jar" + "\"");
        args.add("-Xbootclasspath/p:\"" + this.bundlePath + "/modules/org/apache/log4j/main/log4j-1.2.16.jar" + "\"");
        args.add("-Djboss.modules.system.pkgs=org.jboss.logmanager");
        args.add("-Dorg.jboss.boot.log.file=\"" + this.bundlePath.append("/standalone/log/boot.log") + "\"");
        args.add("-Dlogging.configuration=file:\"" + this.bundlePath + "/standalone/configuration/logging.properties" + "\"");
        args.add("-Djboss.home.dir=\"" + this.bundlePath + "\"");
        args.add("-Djboss.bind.address.management=localhost");
        args.add("-Duser.timezone=GMT");
        return args.toArray(new String[0]);
    }

    @Override
    public String[] getRuntimeStopVMArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Djboss.home.dir=\"" + this.bundlePath + "\"");
        return args.toArray(new String[0]);
    }

    @Override
    public String getType() {
        return "JBoss AS";
    }

    @Override
    public IPath[] getUserLibs() {
        ArrayList<Path> libs = new ArrayList<Path>();
        try {
            List portallibFiles = FileListing.getFileListing((File)new File(this.getAppServerPortalDir().append("WEB-INF/lib").toPortableString()));
            for (File lib : portallibFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            List libFiles = FileListing.getFileListing((File)new File(this.getAppServerLibDir().toPortableString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return libs.toArray(new IPath[libs.size()]);
    }
}

