/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.ILiferayServerBehavior;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalRuntime;
import com.liferay.ide.server.core.portal.PortalServer;
import com.liferay.ide.server.util.PingThread;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class PortalServerBehavior
extends ServerBehaviourDelegate
implements ILiferayServerBehavior,
IJavaLaunchConfigurationConstants {
    public static final String ATTR_STOP = "stop-server";
    private static final String[] JMX_EXCLUDE_ARGS = new String[]{"-Dcom.sun.management.jmxremote", "-Dcom.sun.management.jmxremote.port=", "-Dcom.sun.management.jmxremote.ssl=", "-Dcom.sun.management.jmxremote.authenticate="};
    private IAdaptable info;
    private transient PingThread ping = null;
    private transient IDebugEventSetListener processListener;
    private BundleSupervisor _bundleSupervisor;

    public void addProcessListener(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        if (newProcess != null && newProcess.equals(event.getSource()) && event.getKind() == 8) {
                            PortalServerBehavior.this.cleanup();
                        }
                        ++n2;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    public void cleanup() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    public String getClassToLaunch() {
        return this.getPortalRuntime().getPortalBundle().getMainClass();
    }

    @Override
    public IPath getDeployedPath(IModule[] module) {
        return null;
    }

    public IAdaptable getInfo() {
        return this.info;
    }

    private int getNextToken(String s, int start) {
        int i = start;
        int length = s.length();
        int lookFor = 32;
        while (i < length) {
            int c = s.charAt(i);
            if (lookFor == c) {
                if (lookFor == 34) {
                    return i + 1;
                }
                return i;
            }
            if (c == 34) {
                lookFor = 34;
            }
            ++i;
        }
        return -1;
    }

    private PortalRuntime getPortalRuntime() {
        PortalRuntime retval = null;
        if (this.getServer().getRuntime() != null) {
            retval = (PortalRuntime)this.getServer().getRuntime().loadAdapter(PortalRuntime.class, null);
        }
        return retval;
    }

    private PortalServer getPortalServer() {
        PortalServer retval = null;
        if (this.getServer() != null) {
            retval = (PortalServer)this.getServer().loadAdapter(PortalServer.class, null);
        }
        return retval;
    }

    private String[] getRuntimeStartProgArgs() {
        return this.getPortalRuntime().getPortalBundle().getRuntimeStartProgArgs();
    }

    private String[] getRuntimeStartVMArguments() {
        ArrayList<String> retval = new ArrayList<String>();
        Collections.addAll(retval, this.getPortalServer().getMemoryArgs());
        Collections.addAll(retval, this.getPortalRuntime().getPortalBundle().getRuntimeStartVMArgs());
        int agentPort = this.getServer().getAttribute("AGENT_PORT", 29998);
        retval.add("-DaQute.agent.server.port=" + agentPort);
        return retval.toArray(new String[0]);
    }

    private String[] getRuntimeStopProgArgs() {
        return this.getPortalRuntime().getPortalBundle().getRuntimeStopProgArgs();
    }

    private String[] getRuntimeStopVMArguments() {
        ArrayList retval = new ArrayList();
        Collections.addAll(retval, this.getPortalServer().getMemoryArgs());
        Collections.addAll(retval, this.getPortalRuntime().getPortalBundle().getRuntimeStopVMArgs());
        return retval.toArray(new String[0]);
    }

    public void launchServer(ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            return;
        }
        IStatus status = this.getPortalRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(mode);
        try {
            String url = "http://" + this.getServer().getHost();
            url = String.valueOf(url) + ":8080";
            this.ping = new PingThread(this.getServer(), url, -1, this);
        }
        catch (Exception exception) {
            LiferayServerCore.logError("Can't ping for portal startup.");
        }
    }

    private String mergeArguments(String orgArgsString, String[] newArgs, String[] excludeArgs, boolean keepActionLast) {
        String retval = null;
        if (CoreUtil.isNullOrEmpty((Object[])newArgs) && CoreUtil.isNullOrEmpty((Object[])excludeArgs)) {
            retval = orgArgsString;
        } else {
            int index2;
            String s;
            int index;
            int ind2;
            int ind;
            retval = orgArgsString == null ? "" : orgArgsString;
            int size = newArgs.length;
            int i = 0;
            while (i < size) {
                ind = newArgs[i].indexOf(" ");
                ind2 = newArgs[i].indexOf("=");
                if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                    index = retval.indexOf(newArgs[i].substring(0, ind + 1));
                    if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                        s = retval.substring(0, index);
                        index2 = this.getNextToken(retval, index + ind + 1);
                        retval = index2 >= 0 ? String.valueOf(s) + newArgs[i] + retval.substring(index2) : String.valueOf(s) + newArgs[i];
                        newArgs[i] = null;
                    }
                } else if (ind2 >= 0) {
                    index = retval.indexOf(newArgs[i].substring(0, ind2 + 1));
                    if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                        s = retval.substring(0, index);
                        index2 = this.getNextToken(retval, index);
                        retval = index2 >= 0 ? String.valueOf(s) + newArgs[i] + retval.substring(index2) : String.valueOf(s) + newArgs[i];
                        newArgs[i] = null;
                    }
                } else {
                    index = retval.indexOf(newArgs[i]);
                    if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                        s = retval.substring(0, index);
                        index2 = this.getNextToken(retval, index);
                        if (!keepActionLast || i < size - 1) {
                            retval = index2 >= 0 ? String.valueOf(s) + newArgs[i] + retval.substring(index2) : String.valueOf(s) + newArgs[i];
                            newArgs[i] = null;
                        } else {
                            retval = index2 >= 0 ? String.valueOf(s) + retval.substring(index2) : s;
                        }
                    }
                }
                ++i;
            }
            if (excludeArgs != null && excludeArgs.length > 0) {
                i = 0;
                while (i < excludeArgs.length) {
                    ind = excludeArgs[i].indexOf(" ");
                    ind2 = excludeArgs[i].indexOf("=");
                    if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                        index = retval.indexOf(excludeArgs[i].substring(0, ind + 1));
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            s = retval.substring(0, index);
                            index2 = this.getNextToken(retval, index + ind + 1);
                            if (index2 >= 0) {
                                while (index2 < retval.length() && Character.isWhitespace(retval.charAt(index2))) {
                                    ++index2;
                                }
                                retval = String.valueOf(s) + retval.substring(index2);
                            } else {
                                retval = s;
                            }
                        }
                    } else if (ind2 >= 0) {
                        index = retval.indexOf(excludeArgs[i].substring(0, ind2 + 1));
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            s = retval.substring(0, index);
                            index2 = this.getNextToken(retval, index);
                            if (index2 >= 0) {
                                while (index2 < retval.length() && Character.isWhitespace(retval.charAt(index2))) {
                                    ++index2;
                                }
                                retval = String.valueOf(s) + retval.substring(index2);
                            } else {
                                retval = s;
                            }
                        }
                    } else {
                        index = retval.indexOf(excludeArgs[i]);
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            s = retval.substring(0, index);
                            index2 = this.getNextToken(retval, index);
                            if (index2 >= 0) {
                                while (index2 < retval.length() && Character.isWhitespace(retval.charAt(index2))) {
                                    ++index2;
                                }
                                retval = String.valueOf(s) + retval.substring(index2);
                            } else {
                                retval = s;
                            }
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < size) {
                if (newArgs[i] != null) {
                    if (retval.length() > 0 && !retval.endsWith(" ")) {
                        retval = String.valueOf(retval) + " ";
                    }
                    retval = String.valueOf(retval) + newArgs[i];
                }
                ++i;
            }
        }
        return retval;
    }

    private void mergeClasspath(List<IRuntimeClasspathEntry> oldCpEntries, IRuntimeClasspathEntry cpEntry) {
        for (IRuntimeClasspathEntry oldCpEntry : oldCpEntries) {
            if (!oldCpEntry.getPath().equals((Object)cpEntry.getPath())) continue;
            return;
        }
        oldCpEntries.add(cpEntry);
    }

    public void publish(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        this.info = info;
        super.publish(kind, modules, monitor, info);
        this.info = null;
    }

    protected void publishModule(int kind, int deltaKind, IModule[] modules, IProgressMonitor monitor) throws CoreException {
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.setServerPublishState(1);
    }

    @Override
    public void redeployModule(final IModule[] module) throws CoreException {
        this.setModulePublishState(module, 3);
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                if (IModule.class.equals((Object)adapter)) {
                    return module[0];
                }
                return null;
            }
        };
        ArrayList<IModule[]> modules = new ArrayList<IModule[]>();
        modules.add(module);
        this.publish(2, modules, null, info);
    }

    private void replaceJREConatiner(List<IRuntimeClasspathEntry> oldCp, IRuntimeClasspathEntry newJRECp) {
        int size = oldCp.size();
        int i = 0;
        while (i < size) {
            IRuntimeClasspathEntry entry2 = oldCp.get(i);
            if (entry2.getPath().uptoSegment(2).isPrefixOf(newJRECp.getPath())) {
                oldCp.set(i, newJRECp);
                return;
            }
            ++i;
        }
        oldCp.add(0, newJRECp);
    }

    public void setModulePublishState2(IModule[] module, int state) {
        super.setModulePublishState(module, state);
    }

    public void setServerStarted() {
        try {
            this.startBundleSupervisor();
            this.setServerState(2);
        }
        catch (Exception e) {
            LiferayServerCore.logError("Error starting bundle supervisor", e);
        }
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy launch, IProgressMonitor monitor) throws CoreException {
        String existingProgArgs = launch.getAttribute(ATTR_PROGRAM_ARGUMENTS, null);
        launch.setAttribute(ATTR_PROGRAM_ARGUMENTS, this.mergeArguments(existingProgArgs, this.getRuntimeStartProgArgs(), null, true));
        String existingVMArgs = launch.getAttribute(ATTR_VM_ARGUMENTS, null);
        String[] configVMArgs = this.getRuntimeStartVMArguments();
        launch.setAttribute(ATTR_VM_ARGUMENTS, this.mergeArguments(existingVMArgs, configVMArgs, null, false));
        PortalRuntime portalRuntime = this.getPortalRuntime();
        IVMInstall vmInstall = portalRuntime.getVMInstall();
        if (vmInstall != null) {
            launch.setAttribute(ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        IRuntimeClasspathEntry[] orgClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)launch);
        int orgClasspathSize = orgClasspath.length;
        ArrayList<IRuntimeClasspathEntry> oldCp = new ArrayList<IRuntimeClasspathEntry>(orgClasspathSize);
        Collections.addAll(oldCp, orgClasspath);
        List<IRuntimeClasspathEntry> runCpEntries = portalRuntime.getRuntimeClasspathEntries();
        for (IRuntimeClasspathEntry cpEntry : runCpEntries) {
            this.mergeClasspath(oldCp, cpEntry);
        }
        if (vmInstall != null) {
            IPath toolsPath;
            try {
                String typeId = vmInstall.getVMInstallType().getId();
                IRuntimeClasspathEntry newJRECp = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2);
                this.replaceJREConatiner(oldCp, newJRECp);
            }
            catch (Exception exception) {}
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            if (jrePath != null && (toolsPath = jrePath.append("lib/tools.jar")).toFile().exists()) {
                IRuntimeClasspathEntry toolsJar = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath);
                int toolsIndex = 0;
                while (toolsIndex < oldCp.size()) {
                    IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)oldCp.get(toolsIndex);
                    if (entry.getType() == 2 && entry.getPath().lastSegment().equals("tools.jar")) break;
                    ++toolsIndex;
                }
                if (toolsIndex < oldCp.size()) {
                    oldCp.set(toolsIndex, toolsJar);
                } else {
                    this.mergeClasspath(oldCp, toolsJar);
                }
            }
        }
        ArrayList<String> cp = new ArrayList<String>();
        for (IRuntimeClasspathEntry entry : oldCp) {
            try {
                cp.add(entry.getMemento());
            }
            catch (Exception e) {
                LiferayServerCore.logError("Could not resolve cp entry " + entry, e);
            }
        }
        launch.setAttribute(ATTR_CLASSPATH, cp);
        launch.setAttribute(ATTR_DEFAULT_CLASSPATH, false);
        this.setupAgent();
    }

    private void setupAgent() {
        IPath modulesPath = this.getPortalRuntime().getPortalBundle().getLiferayHome().append("osgi/modules");
        IPath agentInstalledPath = modulesPath.append("biz.aQute.remote.agent.jar");
        if (!agentInstalledPath.toFile().exists()) {
            try {
                File file = new File(FileLocator.toFileURL((URL)LiferayServerCore.getDefault().getBundle().getEntry("bundles/biz.aQute.remote.agent-3.1.0.jar")).getFile());
                FileUtil.copyFile((File)file, (File)modulesPath.append("biz.aQute.remote.agent.jar").toFile());
            }
            catch (IOException iOException) {}
        }
    }

    public void stop(boolean force) {
        try {
            this.stopBundleSupervisor();
        }
        catch (IOException iOException) {}
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4 || state == 3) {
            return;
        }
        if (state == 1) {
            this.terminate();
            return;
        }
        try {
            if (state != 4) {
                this.setServerState(3);
            }
            ILaunchConfiguration launchConfig = ((Server)this.getServer()).getLaunchConfiguration(false, null);
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            String args = PortalServerBehavior.renderCommandLine(this.getRuntimeStopProgArgs(), " ");
            String existingVMArgs = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            if (existingVMArgs.indexOf(JMX_EXCLUDE_ARGS[0]) >= 0) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.mergeArguments(existingVMArgs, this.getRuntimeStopVMArguments(), JMX_EXCLUDE_ARGS, false));
            } else {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.mergeArguments(existingVMArgs, this.getRuntimeStopVMArguments(), null, true));
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute(ATTR_STOP, "true");
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            LiferayServerCore.logError("Error stopping portal", e);
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            ILaunch launch = this.getServer().getLaunch();
            if (launch != null) {
                launch.terminate();
                this.cleanup();
            }
        }
        catch (Exception e) {
            LiferayServerCore.logError("Error killing the process", e);
        }
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public BundleSupervisor getBundleSupervisor() {
        return this._bundleSupervisor;
    }

    public void startBundleSupervisor() throws Exception {
        this._bundleSupervisor = new BundleSupervisor();
        int agentPort = this.getServer().getAttribute("AGENT_PORT", 29998);
        this._bundleSupervisor.connect(this.getServer().getHost(), agentPort);
    }

    public void stopBundleSupervisor() throws IOException {
        if (this._bundleSupervisor != null) {
            try {
                this._bundleSupervisor.close();
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to close bundle supervisor", e);
            }
        }
    }
}

