/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.server.core.LiferayServerCore;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SocketUtil {
    public static IStatus canConnect(String host, String port) {
        return SocketUtil.canConnect(new Socket(), host, port);
    }

    public static IStatus canConnect(Socket socket, String host, String port) {
        IStatus status;
        block23: {
            status = null;
            InputStream in = null;
            try {
                try {
                    InetSocketAddress address = new InetSocketAddress(host, (int)Integer.valueOf(port));
                    InetSocketAddress local = new InetSocketAddress(0);
                    socket.bind(local);
                    socket.connect(address);
                    in = socket.getInputStream();
                    status = Status.OK_STATUS;
                }
                catch (Exception exception) {
                    status = LiferayServerCore.error(Msgs.notConnect);
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return status;
    }

    public static IStatus canConnectProxy(String host, String port) {
        return SocketUtil.canConnectProxy(new Socket(), host, port);
    }

    public static IStatus canConnectProxy(Socket socket, String host, String port) {
        IProxyService proxyService = LiferayCore.getProxyService();
        try {
            IProxyData data;
            IProxyData[] proxyDataForHost;
            URI uri = new URI("http://" + host + ":" + port);
            IProxyData[] iProxyDataArray = proxyDataForHost = proxyService.select(uri);
            int n = proxyDataForHost.length;
            int n2 = 0;
            while (n2 < n) {
                data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    return SocketUtil.canConnect(socket, data.getHost(), String.valueOf(data.getPort()));
                }
                ++n2;
            }
            uri = new URI("SOCKS://" + host + ":" + port);
            iProxyDataArray = proxyDataForHost;
            n = proxyDataForHost.length;
            n2 = 0;
            while (n2 < n) {
                data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    return SocketUtil.canConnect(socket, data.getHost(), String.valueOf(data.getPort()));
                }
                ++n2;
            }
        }
        catch (URISyntaxException e) {
            LiferayServerCore.logError("Could not read proxy data", e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPortAvailable(String port) {
        ServerSocket serverSocket = null;
        serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress(Integer.parseInt(port)));
        if (serverSocket == null) return true;
        try {
            serverSocket.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (serverSocket == null) return false;
            }
            catch (Throwable throwable) {
                if (serverSocket == null) throw throwable;
                try {
                    serverSocket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                serverSocket.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private static class Msgs
    extends NLS {
        public static String notConnect;

        static {
            Msgs.initializeMessages((String)SocketUtil.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

