/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.core.debugger;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import tern.TernException;
import tern.eclipse.ide.server.nodejs.core.debugger.INodejsDebugger;
import tern.eclipse.ide.server.nodejs.core.debugger.INodejsDebuggerDelegate;
import tern.eclipse.ide.server.nodejs.internal.core.Trace;
import tern.server.nodejs.process.INodejsProcess;

public class NodejsDebuggersManager {
    private static final String EXT_NODEJS_DEBUGGERS = "nodeJSDebuggers";
    private static final String EL_DEBUGGER = "debugger";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private static Map<String, INodejsDebugger> debuggers = new LinkedHashMap<String, INodejsDebugger>();

    static {
        NodejsDebuggersManager.loadExtensionPoint();
        debuggers = Collections.unmodifiableMap(debuggers);
    }

    public static Collection<INodejsDebugger> getDebuggers() {
        return debuggers.values();
    }

    private static void loadExtensionPoint() {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("tern.eclipse.ide.server.nodejs.core", EXT_NODEJS_DEBUGGERS);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(EL_DEBUGGER)) {
                try {
                    NodejsDebuggersManager.addDebugger(new NodejsDebugger(el));
                }
                catch (Exception ex) {
                    Trace.trace((byte)3, ex.getMessage(), ex);
                }
            }
            ++n2;
        }
    }

    private static void addDebugger(INodejsDebugger debugger) {
        debuggers.put(debugger.getId(), debugger);
    }

    public static INodejsDebugger getDebugger(String debugger) {
        if (debugger == null) {
            return null;
        }
        return debuggers.get(debugger);
    }

    private static class NodejsDebugger
    implements INodejsDebugger {
        private INodejsDebuggerDelegate delegate;
        private String name;
        private String id;

        public NodejsDebugger(IConfigurationElement el) throws Exception {
            this.name = el.getAttribute(NodejsDebuggersManager.ATTR_NAME);
            this.id = el.getAttribute(NodejsDebuggersManager.ATTR_ID);
            this.delegate = (INodejsDebuggerDelegate)el.createExecutableExtension(NodejsDebuggersManager.ATTR_CLASS);
            if (this.name == null || this.name.trim().isEmpty()) {
                throw new RuntimeException("Debugger name cannot be empty");
            }
            if (this.id == null || this.id.trim().isEmpty()) {
                throw new RuntimeException("Debugger id cannot be empty");
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isInstalled() {
            return this.delegate.isInstalled();
        }

        @Override
        public INodejsProcess createProcess(File projectDir, File nodejsBaseDir, IFile ternServerFile) throws TernException {
            return this.delegate.createProcess(projectDir, nodejsBaseDir, ternServerFile);
        }
    }
}

